/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.simsilica.lemur.ValueRenderers;
import com.simsilica.lemur.text.TextFilters;
import com.simsilica.lemur.value.TextFieldValueEditor;

public class ValueEditors {
    public static TextFieldValueEditor<Double> doubleEditor(String format) {
        TextFieldValueEditor<Double> result = new TextFieldValueEditor<Double>(ValueRenderers.formatString(format), ValueEditors.toDouble());
        result.getDocumentModelFilter().setInputTransform(TextFilters.charFilter((Predicate)TextFilters.isInChars((char[])new char[]{'-', '.', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'})));
        return result;
    }

    public static Function<String, Double> toDouble() {
        return new StringToDouble();
    }

    public static class StringToDouble
    implements Function<String, Double> {
        public Double apply(String s) {
            if (s == null) {
                return null;
            }
            return Double.parseDouble(s);
        }
    }
}

