/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim;

import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.trans.PositionTransition3d;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathBuffer {
    static Logger log = LoggerFactory.getLogger(PathBuffer.class);
    private List<PositionTransition3d> frames = new ArrayList<PositionTransition3d>();
    private PositionTransition3d lastFrame;
    private Long startTime = null;

    public void addFrame(long time, Vec3d pos, Quatd rot) {
        if (this.startTime == null) {
            this.startTime = time;
            time = 0L;
        } else {
            time -= this.startTime.longValue();
        }
        PositionTransition3d frame = new PositionTransition3d(time, pos.clone(), rot.clone(), true);
        if (this.lastFrame != null) {
            frame.setPreviousTransition(this.lastFrame);
        }
        this.frames.add(frame);
        this.lastFrame = frame;
    }

    public long getDuration() {
        return this.startTime == null ? 0L : this.lastFrame.getEndTime() - this.startTime;
    }

    public List<PositionTransition3d> getFrames() {
        return this.frames;
    }
}

