/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.scene.Node;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Selector;
import com.simsilica.lemur.TextField;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.props.PropertyPanel;
import com.simsilica.lemur.text.DocumentModel;
import java.util.List;
import mythruna.client.GameSessionState;
import mythruna.client.GameSettingsState;
import mythruna.client.MythrunaConfig;
import mythruna.client.ui.FontType;
import mythruna.client.ui.FontTypeIndex;
import mythruna.client.ui.ScreenAnnotation;
import mythruna.client.ui.ScreenAnnotationsState;
import mythruna.net.DataSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverlaySettingsState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(OverlaySettingsState.class);
    public static final String MAIN_OVERLAY = "overlay.main";
    public static final String SIGNATURE_OVERLAY = "overlay.signature";
    private ScreenAnnotation sigBlock;
    private TextField sigBlockText;
    private VersionedList<FontType> fonts = new VersionedList();
    private Selector<FontType> sigFont;
    private VersionedReference<FontType> sigFontRef;
    private VersionedReference<DocumentModel> sigBlockTextRef;
    private VersionedList<Anchor> anchors = new VersionedList(List.of(new Anchor(this, "Top Left", new Vector2f(-1.0f, 1.0f)), new Anchor(this, "Top", new Vector2f(0.0f, 1.0f)), new Anchor(this, "Top Right", new Vector2f(1.0f, 1.0f)), new Anchor(this, "Right", new Vector2f(1.0f, 0.0f)), new Anchor(this, "Bottom Right", new Vector2f(1.0f, -1.0f)), new Anchor(this, "Bottom", new Vector2f(0.0f, -1.0f)), new Anchor(this, "Bottom Left", new Vector2f(-1.0f, -1.0f)), new Anchor(this, "Left", new Vector2f(-1.0f, 0.0f))));
    private Anchor defaultAnchor = (Anchor)this.anchors.get(2);
    private ScreenAnnotation overlay;
    private TextField overlayText;
    private Selector<FontType> overlayFont;
    private VersionedReference<FontType> overlayFontRef;
    private VersionedReference<DocumentModel> overlayTextRef;
    private Selector<Anchor> overlayAnchor;
    private VersionedReference<Anchor> overlayAnchorRef;
    private boolean handDrawnEnabled = false;
    private boolean mainOverlayEnabled = false;

    public void setHandDrawnEnabled(boolean handDrawnEnabled) {
        if (this.handDrawnEnabled == handDrawnEnabled) {
            return;
        }
        this.handDrawnEnabled = handDrawnEnabled;
        this.resetMode();
    }

    public void setMainOverlayEnabled(boolean mainOverlayEnabled) {
        if (this.mainOverlayEnabled == mainOverlayEnabled) {
            return;
        }
        this.mainOverlayEnabled = mainOverlayEnabled;
        this.resetMode();
    }

    protected void resetMode() {
        ScreenAnnotationsState annot = (ScreenAnnotationsState)this.getState(ScreenAnnotationsState.class, true);
        annot.setEnabled(this.handDrawnEnabled || this.mainOverlayEnabled);
        if (this.handDrawnEnabled) {
            if (this.sigFont.getSelectedItem() == null && !this.fonts.isEmpty()) {
                this.sigFont.setSelectedItem((Object)((FontType)this.fonts.get(0)));
            }
            this.sigBlock.setExpression(this.sigBlockText.getText());
            if (this.sigFontRef.get() == null) {
                this.sigBlock.setFont(null);
            } else {
                this.sigBlock.setFont(((FontType)this.sigFontRef.get()).getFont());
            }
            annot.addAnnotation(this.sigBlock);
        } else {
            annot.removeAnnotation(this.sigBlock);
        }
        if (this.mainOverlayEnabled && !this.handDrawnEnabled) {
            if (this.overlayFont.getSelectedItem() == null && !this.fonts.isEmpty()) {
                this.overlayFont.setSelectedItem((Object)((FontType)this.fonts.get(0)));
            }
            this.overlay.setExpression(this.overlayText.getText());
            if (this.overlayFontRef.get() == null) {
                this.overlay.setFont(null);
            } else {
                this.overlay.setFont(((FontType)this.overlayFontRef.get()).getFont());
            }
            annot.addAnnotation(this.overlay);
        } else {
            annot.removeAnnotation(this.overlay);
        }
    }

    protected FontType findFont(String name) {
        for (FontType font : this.fonts) {
            if (!name.equals(font.getName()) && !name.equals(font.getFont())) continue;
            return font;
        }
        return this.fonts.isEmpty() ? null : (FontType)this.fonts.get(0);
    }

    protected ScreenAnnotation createMainOverlay() {
        String json = MythrunaConfig.getInstance().getStartupSetting(MAIN_OVERLAY, null);
        if (json != null) {
            try {
                return ScreenAnnotation.fromJson(json);
            }
            catch (RuntimeException e) {
                log.error("Error parsing json:" + json, (Throwable)e);
            }
        }
        ScreenAnnotation result = new ScreenAnnotation("$seed\n$coordinate");
        result.setAngle(0.0f);
        result.setAnchor(this.defaultAnchor.pos);
        result.setScale(0.8f);
        result.setColor(ColorRGBA.White);
        result.setShadowColor(ColorRGBA.Black);
        return result;
    }

    protected ScreenAnnotation createHandDrawnOverlay() {
        String json = MythrunaConfig.getInstance().getStartupSetting(SIGNATURE_OVERLAY, null);
        if (json != null) {
            try {
                return ScreenAnnotation.fromJson(json);
            }
            catch (RuntimeException e) {
                log.error("Error parsing json:" + json, (Throwable)e);
            }
        }
        ScreenAnnotation result = new ScreenAnnotation("$character $seed\n$coordinate");
        result.setAngle(25.0f);
        result.setScale(0.8f);
        result.setFont("Hand 3");
        return result;
    }

    protected void initialize(Application app) {
        DataSession dataSession = ((GameSessionState)this.getState(GameSessionState.class, true)).getDataSession();
        FontTypeIndex fontIndex = FontTypeIndex.create(key -> dataSession.getText(key));
        this.fonts.addAll(fontIndex.getFontTypes());
        Container overlays = ((GameSettingsState)this.getState(GameSettingsState.class)).getMainOverlayPanel();
        overlays.addChild((Node)new Label("Overlay Text:"), new Object[0]);
        this.overlay = this.createMainOverlay();
        this.overlayText = (TextField)overlays.addChild((Node)new TextField(this.overlay.getExpression()), new Object[0]);
        this.overlayText.setSingleLine(false);
        this.overlayText.setPreferredLineCount(2);
        this.overlayTextRef = this.overlayText.getDocumentModel().createReference();
        Container nonProps = (Container)overlays.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.None, FillMode.Last)), new Object[0]);
        nonProps.addChild((Node)new Label("Font:"), new Object[0]);
        this.overlayFont = (Selector)nonProps.addChild((Node)new Selector(this.fonts), new Object[]{1});
        this.overlayFont.setSelectedItem((Object)this.findFont(this.overlay.getFont()));
        this.overlayFontRef = this.overlayFont.createSelectedItemReference();
        nonProps.addChild((Node)new Label("Anchor:"), new Object[0]);
        this.overlayAnchor = (Selector)nonProps.addChild((Node)new Selector(this.anchors), new Object[]{1});
        this.overlayAnchorRef = this.overlayAnchor.createSelectedItemReference();
        this.overlayAnchor.setSelectedItem((Object)this.defaultAnchor);
        PropertyPanel props = new PropertyPanel(null);
        overlays.addChild((Node)props, new Object[0]);
        props.addBooleanProperty("Enabled", (Object)this.overlay, "enabled");
        props.addFloatProperty("Scale", (Object)this.overlay, "scale", 0.5f, 2.0f, 0.1f);
        props.addFloatProperty("Angle", (Object)this.overlay, "angle", -90.0f, 90.0f, 5.0f);
        overlays = ((GameSettingsState)this.getState(GameSettingsState.class)).getHandDrawnOverlayPanel();
        overlays.addChild((Node)new Label("Signature Block:"), new Object[0]);
        this.sigBlock = this.createHandDrawnOverlay();
        this.sigBlockText = (TextField)overlays.addChild((Node)new TextField(this.sigBlock.getExpression()), new Object[0]);
        this.sigBlockText.setSingleLine(false);
        this.sigBlockText.setPreferredLineCount(2);
        this.sigBlockTextRef = this.sigBlockText.getDocumentModel().createReference();
        nonProps = (Container)overlays.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.None, FillMode.Last)), new Object[0]);
        nonProps.addChild((Node)new Label("Font:"), new Object[0]);
        this.sigFont = (Selector)nonProps.addChild((Node)new Selector(this.fonts), new Object[]{1});
        this.sigFont.setSelectedItem((Object)this.findFont(this.sigBlock.getFont()));
        this.sigFontRef = this.sigFont.createSelectedItemReference();
        props = new PropertyPanel(null);
        overlays.addChild((Node)props, new Object[0]);
        props.addBooleanProperty("Enabled", (Object)this.sigBlock, "enabled");
        props.addFloatProperty("Scale", (Object)this.sigBlock, "scale", 0.5f, 2.0f, 0.1f);
        props.addFloatProperty("Angle", (Object)this.sigBlock, "angle", -90.0f, 90.0f, 5.0f);
    }

    protected void cleanup(Application app) {
        Container overlays = ((GameSettingsState)this.getState(GameSettingsState.class)).getHandDrawnOverlayPanel();
        overlays.clearChildren();
        try {
            log.info("Saving overlays...");
            String json = this.overlay.toJson();
            MythrunaConfig.getInstance().getStartupSettings().put(MAIN_OVERLAY, json);
            json = this.sigBlock.toJson();
            MythrunaConfig.getInstance().getStartupSettings().put(SIGNATURE_OVERLAY, json);
            MythrunaConfig.save();
        }
        catch (RuntimeException e) {
            log.error("Error saving overlays", (Throwable)e);
        }
    }

    protected void onEnable() {
        this.setHandDrawnEnabled(((GameSettingsState)this.getState(GameSettingsState.class, true)).isHandDrawnEnabled());
        this.setMainOverlayEnabled(!((GameSettingsState)this.getState(GameSettingsState.class, true)).isDebugHudEnabled());
    }

    protected void onDisable() {
    }

    public void update(float tpf) {
        if (this.handDrawnEnabled) {
            if (this.sigBlockTextRef.update()) {
                this.sigBlock.setExpression(this.sigBlockText.getText());
            }
            if (this.sigFontRef.update()) {
                this.sigBlock.setFont(((FontType)this.sigFontRef.get()).getFont());
            }
        } else if (this.mainOverlayEnabled) {
            if (this.overlayTextRef.update()) {
                this.overlay.setExpression(this.overlayText.getText());
            }
            if (this.overlayFontRef.update()) {
                this.overlay.setFont(((FontType)this.overlayFontRef.get()).getFont());
            }
            if (this.overlayAnchorRef.update()) {
                this.overlay.setAnchor(((Anchor)this.overlayAnchorRef.get()).pos);
            }
        }
    }

    private class Anchor {
        String name;
        Vector2f pos;

        public Anchor(OverlaySettingsState overlaySettingsState, String name, Vector2f pos) {
            this.name = name;
            this.pos = pos;
        }

        public String toString() {
            return this.name;
        }
    }
}

