/*
 * Copyright (c) 2023, Simsilica, LLC
 * All rights reserved.
 */

findDefaultBlueprints  = {
    def parent = worldManager.worldEntity;
    def filter = Filters.fieldEquals(BlueprintInfo.class, "parent", parent);
    return entityData.findEntities(filter, BlueprintInfo.class); 
} 

createDefaultBlueprint = { String bpName, String objectName, String blocks, boolean carved, double scale ->
    def parent = worldManager.worldEntity;
    def cells = loadCellsForName(blocks);
    if( cells == null ) {
        throw new IllegalArgumentException("Blocks not found for:" + blocks);
    }
    log.info("Creating default blueprint:" + bpName + "  blocks:" + blocks);
    return createBlueprintFromCells(parent, bpName, objectName, cells, carved, scale);
}
 
copyBlueprint = { EntityId bp, EntityId target ->
    def bpInfo = bp[BlueprintInfo];
    if( bpInfo == null ) {
        throw new IllegalArgumentException("Entity is not a blueprint:" + bp);
    }
    EntityId entity = findBlueprint(target, bpInfo.getName());
    if( entity != null ) {
        log.info("Player:" + target + " already has bp:" + bpInfo);
        // So let's not blow away any changes they might have made already
        return;
    } else {
        log.info("Creating:" + bpInfo + " on player:" + target);
        entity = entityData.createEntity();
    }

    entityData.setComponents(entity,
        bpInfo.changeParent(target),
        bp[ObjectName],
        bp[ShapeInfo],
        bp[CreatedBy]
        );
        
    return entity;    
}
 
// Make sure we have some standard blueprints created
if( true ) {
    log.info("Creating default blueprints..."); 
    createDefaultBlueprint("Chair", "Chair", "/Models/objects/chair.blocks", false, 0.25);
    createDefaultBlueprint("Desk", "Desk", "/Models/objects/desk.blocks", true, 0.25);
    createDefaultBlueprint("Stool", "Stool", "/Models/objects/stool.blocks", false, 0.25);
    createDefaultBlueprint("Table", "Table", "/Models/objects/table.blocks", false, 0.25);
} 
 

// When a player entity is created, we want to add some
// standard blueprints for them.
on( playerEntityCreated ) { event ->
    //log.info("Adding default blueprints to:" + event);
}

on( playerEntityJoining ) { event ->
    log.info("blueprint tests...");
 
    // Copy the standard blueprints
    log.info("Adding default blueprints to:" + event.player);   
    findDefaultBlueprints().each {
        log.info("Blueprint:" + it);
        copyBlueprint(it, event.player);
    }
}
