/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.io;

import com.simsilica.mblock.io.BlockTypeData;
import com.simsilica.mblock.io.UpdateableData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataUpdater<T extends UpdateableData<T>> {
    static Logger log = LoggerFactory.getLogger(DataUpdater.class);
    private File target;
    private File savedSource;
    private T local;

    public DataUpdater(File target) {
        this.target = target;
        this.savedSource = new File(target.getParentFile(), "last-global-" + target.getName());
    }

    public T getData() {
        return this.local;
    }

    public boolean update(T global) throws IOException {
        this.local = this.read(this.target);
        boolean changed = false;
        if (this.local == null) {
            log.info("Initializing " + this.target + " with source data.");
            this.local = global;
            changed = true;
        } else {
            log.info("Checking for " + this.target + " upgrades.");
            T lastGlobal = this.read(this.savedSource);
            if (lastGlobal != null) {
                log.info("Comparing last source data " + this.savedSource + " snapshot...");
                changed = lastGlobal.update(global);
            } else {
                changed = true;
            }
            if (changed) {
                log.info("Upgrading " + this.target + " to source data...");
                this.local.update(global);
            }
        }
        if (changed) {
            log.info("Storing updated " + this.target);
            this.write(this.local, this.target);
            log.info("Storing source snapshot " + this.savedSource);
            this.write(global, this.savedSource);
        }
        return changed;
    }

    public abstract T read(InputStream var1) throws IOException;

    public abstract void write(T var1, OutputStream var2) throws IOException;

    public T read(String resource) throws IOException {
        URL u = BlockTypeData.class.getResource(resource);
        if (u == null) {
            return null;
        }
        return this.read(u.openStream());
    }

    public T read(File f) throws IOException {
        if (!f.exists()) {
            return null;
        }
        return this.read(new FileInputStream(f));
    }

    public void write(T data, File f) throws IOException {
        this.write(data, new FileOutputStream(f));
    }
}

