/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.progress;

import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.progress.ProgressTracker;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressTrackers {
    static Logger log = LoggerFactory.getLogger(ProgressTrackers.class);
    private static ConcurrentHashMap<Thread, ThreadTrackers> trackedThreads = new ConcurrentHashMap();
    private static List<ThreadTrackers> trackersList = new CopyOnWriteArrayList<ThreadTrackers>();
    private static ThreadLocal<ThreadTrackers> threadTrackers = new ThreadLocal<ThreadTrackers>(){

        @Override
        protected ThreadTrackers initialValue() {
            ThreadTrackers trackers = new ThreadTrackers();
            trackedThreads.put(trackers.thread, trackers);
            trackersList.add(trackers);
            return trackers;
        }

        @Override
        public void remove() {
            ThreadTrackers trackers = (ThreadTrackers)this.get();
            if (trackers.thread == Thread.currentThread()) {
                if (log.isTraceEnabled()) {
                    log.trace("Clearing inherited trackers:" + trackers);
                }
                trackedThreads.remove(trackers.thread);
                trackersList.remove(trackers);
            }
            super.remove();
        }
    };
    private static AtomicLong version = new AtomicLong();
    private static Holder versionedObject = new Holder();

    private ProgressTrackers() {
    }

    public static ProgressTracker openTracker(String name) {
        return ProgressTrackers.threadTrackers.get().openTracker(name);
    }

    public static void close(ProgressTracker tracker) {
        ProgressTrackers.threadTrackers.get().close(tracker);
        for (ThreadTrackers trackers : trackersList) {
            if (!trackers.hasTracker(tracker)) continue;
            trackers.close(tracker);
        }
    }

    public static Collection<ThreadTrackers> getThreadTrackers() {
        return Collections.unmodifiableCollection(trackersList);
    }

    public static void inheritThreadTrackers(ThreadTrackers trackers) {
        if (trackers == null) {
            if (threadTrackers.get().thread == Thread.currentThread()) {
                throw new IllegalStateException("Cannot clear a thread's own native trackers");
            }
            threadTrackers.remove();
            return;
        }
        if (!threadTrackers.get().isEmpty()) {
            throw new IllegalStateException("This thread already has active trackers");
        }
        threadTrackers.set(trackers);
    }

    public static ThreadTrackers getThreadTrackers(Thread thread) {
        if (thread == null) {
            return threadTrackers.get();
        }
        return trackedThreads.get(thread);
    }

    public static VersionedReference<Collection<ThreadTrackers>> createReference() {
        return versionedObject.createReference();
    }

    private static class Holder
    implements VersionedObject<Collection<ThreadTrackers>> {
        private Holder() {
        }

        public long getVersion() {
            return version.get();
        }

        public Collection<ThreadTrackers> getObject() {
            return ProgressTrackers.getThreadTrackers();
        }

        public VersionedReference<Collection<ThreadTrackers>> createReference() {
            return new VersionedReference((VersionedObject)this);
        }
    }

    public static class ThreadTrackers
    implements Iterable<ProgressTracker> {
        private Thread thread;
        private List<ProgressTracker> trackers = new CopyOnWriteArrayList<ProgressTracker>();

        public ThreadTrackers() {
            this.thread = Thread.currentThread();
        }

        public Thread getThread() {
            return this.thread;
        }

        @Override
        public Iterator<ProgressTracker> iterator() {
            return Collections.unmodifiableCollection(this.trackers).iterator();
        }

        public boolean isEmpty() {
            return this.trackers.isEmpty();
        }

        public void inherit(ProgressTracker tracker) {
            this.trackers.add(tracker);
        }

        private ProgressTracker openTracker(String name) {
            if (log.isTraceEnabled()) {
                log.trace("openTracker(" + name + ") thread:" + this.thread + "  currentThread:" + Thread.currentThread());
            }
            ProgressTracker tracker = new ProgressTracker(name);
            this.trackers.add(tracker);
            version.incrementAndGet();
            return tracker;
        }

        private boolean hasTracker(ProgressTracker tracker) {
            return this.trackers.contains(tracker);
        }

        private void close(ProgressTracker tracker) {
            int index = this.trackers.indexOf(tracker);
            if (index < 0) {
                throw new IllegalArgumentException("Specified tracker is not open:" + tracker);
            }
            this.trackers.remove(tracker);
            version.incrementAndGet();
        }

        public String toString() {
            return "ThreadTrackers[thread:" + this.thread + ", trackers:" + this.trackers + "]";
        }
    }
}

