/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ethereal.net;

import com.simsilica.ethereal.io.BitInputStream;
import com.simsilica.ethereal.io.BitOutputStream;
import com.simsilica.ethereal.net.ObjectState;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.bits.QuatBits;
import com.simsilica.mathd.bits.Vec3Bits;
import java.io.IOException;

public class ObjectStateProtocol {
    public int zoneIdBitSize;
    public int idBitSize;
    public Vec3Bits positionBits;
    public QuatBits rotationBits;

    public ObjectStateProtocol(int zoneIdBitSize, int idBitSize, Vec3Bits posBits, QuatBits rotBits) {
        this.zoneIdBitSize = zoneIdBitSize;
        this.idBitSize = idBitSize;
        this.positionBits = posBits;
        this.rotationBits = rotBits;
    }

    public void setPosition(ObjectState state, Vec3d pos) {
        state.positionBits = this.positionBits.toBits(pos);
    }

    public Vec3d getPosition(ObjectState state) {
        return this.positionBits.fromBits(state.positionBits);
    }

    public void setRotation(ObjectState state, Quatd rot) {
        state.rotationBits = this.rotationBits.toBits(rot);
    }

    public Quatd getRotation(ObjectState state) {
        return this.rotationBits.fromBits(state.rotationBits);
    }

    public int getEstimatedBitSize(ObjectState state) {
        int size = 16;
        ++size;
        if (state.zoneId != -1) {
            size += this.zoneIdBitSize;
        }
        ++size;
        if (state.realId != null) {
            size += this.idBitSize;
        }
        ++size;
        if (state.parentId != null) {
            size += this.idBitSize;
        }
        ++size;
        if (state.positionBits != -1L) {
            size += this.positionBits.getBitSize();
        }
        ++size;
        if (state.rotationBits != -1L) {
            size += this.rotationBits.getBitSize();
        }
        return size;
    }

    public void writeBits(ObjectState state, BitOutputStream out) throws IOException {
        if (state == null) {
            out.writeBits(0, 16);
            return;
        }
        out.writeBits(state.networkId, 16);
        if (state.networkId == 0) {
            throw new IllegalArgumentException("Object state networkId is 0");
        }
        if (state.zoneId == -1) {
            out.writeBits(0, 1);
        } else {
            out.writeBits(1, 1);
            out.writeBits(state.zoneId, this.zoneIdBitSize);
        }
        if (state.realId == null) {
            out.writeBits(0, 1);
        } else {
            out.writeBits(1, 1);
            out.writeLongBits(state.realId, this.idBitSize);
        }
        if (state.parentId == null) {
            out.writeBits(0, 1);
        } else {
            out.writeBits(1, 1);
            out.writeLongBits(state.parentId, this.idBitSize);
        }
        if (state.positionBits == -1L) {
            out.writeBits(0, 1);
        } else {
            out.writeBits(1, 1);
            out.writeLongBits(state.positionBits, this.positionBits.getBitSize());
        }
        if (state.rotationBits == -1L) {
            out.writeBits(0, 1);
        } else {
            out.writeBits(1, 1);
            out.writeLongBits(state.rotationBits, this.rotationBits.getBitSize());
        }
    }

    public ObjectState readBits(BitInputStream in) throws IOException {
        int networkId = in.readBits(16);
        if (networkId == 0) {
            return null;
        }
        ObjectState state = new ObjectState();
        state.networkId = networkId;
        int bit = in.readBits(1);
        if (bit != 0) {
            state.zoneId = in.readBits(this.zoneIdBitSize);
        }
        if ((bit = in.readBits(1)) != 0) {
            state.realId = in.readLongBits(this.idBitSize);
        }
        if ((bit = in.readBits(1)) != 0) {
            state.parentId = in.readLongBits(this.idBitSize);
        }
        if ((bit = in.readBits(1)) != 0) {
            state.positionBits = in.readLongBits(this.positionBits.getBitSize());
        }
        if ((bit = in.readBits(1)) != 0) {
            state.rotationBits = in.readLongBits(this.rotationBits.getBitSize());
        }
        return state;
    }
}

