/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.local;

import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.FluidUtils;
import com.simsilica.mworld.CellChangeEvent;
import com.simsilica.mworld.CellChangeListener;
import com.simsilica.mworld.FluidData;
import com.simsilica.mworld.transaction.CellEdit;
import java.util.Objects;
import mythruna.world.local.AbstractLocalSpaceValue;
import mythruna.world.local.BasisData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnderwaterValue
extends AbstractLocalSpaceValue<Double, FluidData>
implements CellChangeListener {
    static Logger log = LoggerFactory.getLogger(UnderwaterValue.class);
    public static final double DISTANCE_EPSILON = 1.0E-4;
    public static final double DISTANCE_EPSILON_SQ = 1.0E-8;
    private Vec3d pos = new Vec3d();
    private Vec3i cell = new Vec3i();
    private Vec3d look = new Vec3d();

    public UnderwaterValue(BasisData<FluidData> basis) {
        super(basis, 0.0);
    }

    @Override
    public void updatePosition(Vec3d pos, Vec3i newCell, Vec3d look) {
        boolean changed = false;
        if (pos.distanceSq(this.pos) > 1.0E-8) {
            changed = true;
        }
        if (!look.equals((Object)this.look)) {
            changed = true;
        }
        if (!changed) {
            return;
        }
        this.pos.set(pos);
        this.cell.set(newCell);
        this.look.set(look);
        this.invalidate();
    }

    public void cellChanged(CellChangeEvent event) {
        if (this.isInvalid()) {
            return;
        }
        CellEdit[] edits = event.getFluidChanges();
        if (edits == null) {
            return;
        }
        if (!Objects.equals(event.getLeafId(), ((FluidData)this.getData()).getLeafId())) {
            return;
        }
        this.invalidate();
    }

    protected int getFluidValue() {
        Vec3i origin = ((FluidData)this.getData()).getLeafId().getWorld(null);
        int i = this.cell.x - origin.x;
        int j = this.cell.y - origin.y;
        int k = this.cell.z - origin.z;
        if (i >= 0 && i < 32 && j >= 0 && j < 32 && k >= 0 && k < 32) {
            return ((FluidData)this.getData()).getCell(i, j, k);
        }
        return 0;
    }

    @Override
    protected Double loadValue() {
        int fluidValue = this.getFluidValue();
        int fluidType = FluidUtils.getType((int)fluidValue);
        if (fluidType == 0) {
            return 0.0;
        }
        int fluidLevel = FluidUtils.getLevel((int)fluidValue);
        if (fluidLevel > 7) {
            return 1.0;
        }
        double yFluid = (double)(fluidLevel - 1) / 7.0;
        if (yFluid == 0.0) {
            yFluid += 0.07142857142857142;
        }
        double nearDist = 0.1;
        double yScreen = this.pos.y + this.look.y * nearDist;
        double delta = (yFluid += (double)this.cell.y) - yScreen;
        double svta = yScreen - yFluid;
        double lvta = Math.sqrt(this.look.x * this.look.x + this.look.z * this.look.z);
        if (lvta == 0.0) {
            if (svta > 0.0) {
                return 0.0;
            }
            return 1.0;
        }
        double scale = -svta / lvta;
        double max = 0.07;
        double min = -max;
        if (scale < min) {
            return 0.0;
        }
        if (scale > max) {
            return 1.0;
        }
        return (scale - min) / (max - min);
    }
}

