/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.path;

import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.CellData;
import com.simsilica.mworld.CellDataStack;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.morph.AbstractMorphology;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import mythruna.world.BuildTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoadSection
extends AbstractMorphology {
    static Logger log = LoggerFactory.getLogger(RoadSection.class);
    private Vec3i start;
    private Vec3i end;
    private int width;
    private int type;

    public RoadSection(Vec3i start, Vec3i end, int width, int type) {
        this.start = start;
        this.end = end;
        this.width = width;
        this.type = type;
    }

    public Vec3i getStart() {
        return this.start;
    }

    public Vec3i getEnd() {
        return this.end;
    }

    public int getWidth() {
        return this.width;
    }

    public int getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end, this.width, this.type);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        RoadSection other = (RoadSection)((Object)o);
        if (other.width != this.width) {
            return false;
        }
        if (other.type != this.type) {
            return false;
        }
        if (!Objects.equals(other.start, this.start)) {
            return false;
        }
        return Objects.equals(other.end, this.end);
    }

    public Iterable<Short> getAffectedColumns(TileId tileId) {
        ArrayList<Short> results = new ArrayList<Short>();
        Vec3i origin = tileId.getWorld(null);
        int radius = (int)Math.ceil((double)this.width * 0.5);
        int xMin = Math.min(this.start.x, this.end.x) - radius - origin.x;
        int zMin = Math.min(this.start.z, this.end.z) - radius - origin.z;
        int xMax = Math.max(this.start.x, this.end.x) + radius - origin.x;
        int zMax = Math.max(this.start.z, this.end.z) + radius - origin.z;
        if (xMax < 0 || zMax < 0) {
            return results;
        }
        if (xMin >= 1024 || zMin >= 1024) {
            return results;
        }
        xMin = Math.max(0, xMin);
        xMax = Math.min(xMax, 1023);
        zMin = Math.max(0, zMin);
        zMax = Math.min(zMax, 1023);
        Vec3i min = ColumnId.GRID.worldToCell((double)xMin, 0.0, (double)zMin);
        Vec3i max = ColumnId.GRID.worldToCell((double)xMax, 0.0, (double)zMax);
        for (int x = min.x; x <= max.x; ++x) {
            for (int z = min.z; z <= max.z; ++z) {
                short id = ColumnId.toTileLocalIndexId((int)x, (int)z);
                results.add(id);
            }
        }
        return results;
    }

    private double clamp(double v, double min, double max) {
        if (v <= min) {
            return min;
        }
        if (v >= max) {
            return max;
        }
        return v;
    }

    private int mix(int v1, int v2, double mix) {
        double d = (double)v1 * (1.0 - mix) + (double)v2 * mix;
        return (int)Math.round(d);
    }

    private double smoothStep(double edge0, double edge1, double x) {
        double t = this.clamp((x - edge0) / (edge1 - edge0), 0.0, 1.0);
        return t * t * (3.0 - 2.0 * t);
    }

    public boolean intersects(TileId tileId) {
        Vec3i tileOrigin = tileId.getWorld(null);
        Vec3i min = this.start.clone().minLocal(this.end);
        Vec3i max = this.start.clone().maxLocal(this.end);
        int radius = (int)Math.ceil((double)this.width * 0.5);
        min.subtractLocal(radius, 0, radius);
        max.addLocal(radius, 0, radius);
        if (max.x < tileOrigin.x || max.z < tileOrigin.z) {
            return false;
        }
        return min.x < tileOrigin.x + 1024 && min.z < tileOrigin.z + 1024;
    }

    public double getDistanceSq(Vec3d pos) {
        Vec3d dir = new Vec3d((double)(this.end.x - this.start.x), 0.0, (double)(this.end.z - this.start.z));
        double length = dir.length();
        dir.normalizeLocal();
        Vec3d relative = pos.subtract(this.start);
        relative.y = 0.0;
        double project = dir.dot(relative);
        project = this.clamp(project, 0.0, length);
        Vec3d p = this.start.toVec3d().add(dir.mult(project));
        p.y = 0.0;
        return p.distanceSq(pos.x, 0.0, pos.z);
    }

    public boolean morph(Tile tile, Random rand) {
        TerrainImage terrain = (TerrainImage)tile.get((Object)TerrainImageType.Terrain, TerrainImage.class);
        TerrainImage fluid = (TerrainImage)tile.get((Object)TerrainImageType.Fluid, TerrainImage.class);
        int size = terrain.getSize();
        int spread = 1024 / size;
        TileId tileId = tile.getTileId();
        Vec3i origin = tileId.getWorld(null);
        int extend = (int)Math.ceil((double)this.width * 0.5);
        int xMin = Math.min(this.start.x, this.end.x) - extend - origin.x;
        int zMin = Math.min(this.start.z, this.end.z) - extend - origin.z;
        int xMax = Math.max(this.start.x, this.end.x) + extend - origin.x;
        int zMax = Math.max(this.start.z, this.end.z) + extend - origin.z;
        xMin = Math.max(xMin, 0);
        zMin = Math.max(zMin, 0);
        xMax = Math.min(xMax, 1023);
        zMax = Math.min(zMax, 1023);
        xMin /= spread;
        zMin /= spread;
        xMax /= spread;
        zMax /= spread;
        int yStart = this.start.y;
        int yEnd = this.end.y;
        if (yStart < 128) {
            yStart = 132;
        }
        if (yEnd < 128) {
            yEnd = 132;
        }
        double radius = (double)this.width * 0.5;
        double radiusSq = radius * radius;
        Vec3d dir = new Vec3d((double)(this.end.x - this.start.x), 0.0, (double)(this.end.z - this.start.z));
        double length = dir.length();
        dir.normalizeLocal();
        Vec3d localStart = this.start.subtract(origin).toVec3d();
        localStart.y = 0.0;
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                Vec3d p;
                double dSq;
                double xRel = (double)(x * spread) - localStart.x;
                double zRel = (double)(z * spread) - localStart.z;
                double project = dir.dot(xRel, 0.0, zRel);
                boolean end = false;
                if (project < 0.0 || project > length) {
                    end = true;
                    project = this.clamp(project, 0.0, length);
                }
                if (!((dSq = (p = localStart.add(dir.mult(project))).distanceSq((double)(x * spread), 0.0, (double)(z * spread))) <= radiusSq)) continue;
                int roadLevel = (int)((double)yStart + (double)(yEnd - yStart) * (project / length));
                short y = terrain.getElevation(x, z);
                short waterLevel = fluid.getElevation(x, z);
                if (roadLevel < waterLevel) {
                    roadLevel = y == waterLevel - 1 ? (int)waterLevel : (y == waterLevel - 2 ? waterLevel + 1 : waterLevel + 2);
                }
                if (roadLevel < y) {
                    terrain.setElevation(x, z, (short)roadLevel);
                    terrain.setType(x, z, (byte)5);
                    continue;
                }
                if (roadLevel > y + 2) continue;
                terrain.setElevation(x, z, (short)roadLevel);
                terrain.setType(x, z, (byte)5);
            }
        }
        return false;
    }

    public boolean morph(ColumnData colData, Tile tile, Random rand) {
        BuildTypes types = (BuildTypes)tile.get(BuildTypes.class);
        int cobbleType = types.cobble;
        int stoneType = types.stone4;
        int woodType = types.wood;
        Vec3i origin = colData.getColumnId().getWorld(null);
        Vec3i localOrigin = origin.subtract(tile.getTileId().getWorld(null));
        int yStart = this.start.y;
        int yEnd = this.end.y;
        if (yStart < 128) {
            yStart = 132;
        }
        if (yEnd < 128) {
            yEnd = 132;
        }
        Vec3d dir = new Vec3d((double)(this.end.x - this.start.x), 0.0, (double)(this.end.z - this.start.z));
        double length = dir.length();
        dir.normalizeLocal();
        TerrainImage terrain = (TerrainImage)tile.get((Object)TerrainImageType.Terrain, TerrainImage.class);
        TerrainImage fluid = (TerrainImage)tile.get((Object)TerrainImageType.Fluid, TerrainImage.class);
        Vec3d localStart = this.start.subtract(origin).toVec3d();
        localStart.y = 0.0;
        double radius = (double)this.width * 0.5;
        double radiusSq = radius * radius;
        CellDataStack blocks = new CellDataStack(32, (CellData[])colData.getLeafs());
        boolean changed = false;
        for (int x = 0; x < 32; ++x) {
            for (int z = 0; z < 32; ++z) {
                Vec3d p;
                double dSq;
                double xRel = (double)x - localStart.x;
                double zRel = (double)z - localStart.z;
                double project = dir.dot(xRel, 0.0, zRel);
                boolean end = false;
                if (project < 0.0 || project > length) {
                    end = true;
                    project = this.clamp(project, 0.0, length);
                }
                if (!((dSq = (p = localStart.add(dir.mult(project))).distanceSq((double)x, 0.0, (double)z)) <= radiusSq)) continue;
                int roadLevel = (int)((double)yStart + (double)(yEnd - yStart) * (project / length));
                double roadLevelFraction = (double)yStart + (double)(yEnd - yStart) * (project / length) - (double)roadLevel;
                short y = terrain.getElevation(localOrigin.x + x, localOrigin.z + z);
                short waterLevel = fluid.getElevation(localOrigin.x + x, localOrigin.z + z);
                if (roadLevel < waterLevel) {
                    roadLevel = y == waterLevel - 1 ? (int)waterLevel : (y == waterLevel - 2 ? waterLevel + 1 : waterLevel + 2);
                }
                if (this.type == 0) {
                    blocks.setCell(x, roadLevel, z, cobbleType);
                    blocks.setCell(x, roadLevel - 1, z, stoneType);
                    continue;
                }
                blocks.setCell(x, roadLevel, z, woodType);
            }
        }
        return changed;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[start:" + this.start + ", end:" + this.end + ", type:" + this.type + ", width:" + this.width + "]";
    }
}

