/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld;

import com.google.common.base.MoreObjects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataVersion
implements Cloneable {
    static Logger log = LoggerFactory.getLogger(DataVersion.class);
    private long version;
    private long loadVersion;
    private long loadTimestamp;

    public DataVersion() {
        this(0L, 0L, System.currentTimeMillis());
    }

    public DataVersion(long version) {
        this(version, version, System.currentTimeMillis());
    }

    public DataVersion(long version, long loadVersion) {
        this(version, loadVersion, System.currentTimeMillis());
    }

    public DataVersion(long version, long loadVersion, long loadTimestamp) {
        if (version < loadVersion) {
            throw new IllegalArgumentException("Version " + version + " cannot be less than load version " + loadVersion);
        }
        this.version = version;
        this.loadVersion = loadVersion;
        this.loadTimestamp = loadTimestamp;
    }

    public boolean isTransient() {
        return false;
    }

    public synchronized DataVersion clone() {
        try {
            return (DataVersion)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("we know better", e);
        }
    }

    public synchronized boolean isChanged() {
        return this.version > this.loadVersion;
    }

    public synchronized void markChanged() {
        ++this.version;
    }

    public synchronized void resetChanged(long loadTimestamp) {
        this.loadTimestamp = loadTimestamp;
        this.loadVersion = this.version;
    }

    public synchronized long getVersion() {
        return this.version;
    }

    public synchronized long getLoadVersion() {
        return this.loadVersion;
    }

    public synchronized long getLoadTimestamp() {
        return this.loadTimestamp;
    }

    public synchronized String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("version", this.version).add("loadVersion", this.loadVersion).add("loadTimestamp", this.loadTimestamp).toString();
    }
}

