/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile.morph;

import com.simsilica.ethereal.io.BitInputStream;
import com.simsilica.ethereal.io.BitOutputStream;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.io.ObjectProtocol;
import com.simsilica.mworld.tile.morph.SphereFill;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SphereFillProtocol
implements ObjectProtocol<SphereFill> {
    static Logger log = LoggerFactory.getLogger(SphereFillProtocol.class);
    public static final int X_BITS = 32;
    public static final int Y_BITS = 10;
    public static final int Z_BITS = 32;
    public static final int RADIUS_BITS = 8;
    public static final int BLOCK_FILL_BITS = 16;
    public static final int TERRAIN_FILL_BITS = 16;
    private int version = 0;

    @Override
    public int getProtocolVersion() {
        return this.version;
    }

    @Override
    public void write(SphereFill data, BitOutputStream out) throws IOException {
        out.writeBits(this.version, 8);
        Vec3i center = data.getCenter();
        out.writeBits(center.x, 32);
        out.writeBits(center.y, 10);
        out.writeBits(center.z, 32);
        out.writeBits(data.getRadius(), 8);
        out.writeBits(data.getBlockFill(), 16);
        out.writeBits((int)data.getTerrainFill(), 16);
    }

    @Override
    public SphereFill read(BitInputStream in) throws IOException {
        int version = in.readBits(8);
        int x = in.readBits(32);
        int y = in.readBits(10);
        int z = in.readBits(32);
        int radius = in.readBits(8);
        int blockFill = in.readBits(16);
        byte terrainFill = (byte)in.readBits(16);
        return new SphereFill(new Vec3i(x, y, z), radius, blockFill, terrainFill);
    }
}

