/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.net;

import com.jme3.app.Application;
import com.jme3.network.service.AbstractClientService;
import com.jme3.network.service.ClientServiceManager;
import java.util.concurrent.atomic.AtomicBoolean;
import mythruna.client.net.NetworkState;
import mythruna.fabric.FabricTypeIndex;
import mythruna.fabric.SwatchShapeIndex;
import mythruna.fabric.io.FabricTypeData;
import mythruna.fabric.io.SwatchShapeData;
import mythruna.net.DataSessionListener;
import mythruna.net.client.DataSessionClientService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricIndexSetup
extends AbstractClientService {
    static Logger log = LoggerFactory.getLogger(FabricIndexSetup.class);
    private Application app;
    private NetworkState networkState;
    private DataSessionClientService session;
    private AtomicBoolean dataAvailable = new AtomicBoolean();
    private AtomicBoolean stateReady = new AtomicBoolean();

    public FabricIndexSetup(Application app, NetworkState networkState) {
        this.app = app;
        this.networkState = networkState;
    }

    protected void onInitialize(ClientServiceManager serviceManager) {
        log.info("onInitialize()");
        this.session = (DataSessionClientService)serviceManager.getService(DataSessionClientService.class);
        log.info("session:" + this.session);
        this.session.addDataSessionListener(new DataSessionListener(){

            public void dataAvailable() {
                log.info("dataAVailable()");
                FabricIndexSetup.this.dataAvailable.set(true);
                FabricIndexSetup.this.checkStart();
            }
        });
    }

    public void start() {
        log.info("start()");
    }

    public void setStateReady() {
        log.info("setStateReady()");
        this.stateReady.set(true);
        this.checkStart();
    }

    protected void checkStart() {
        if (this.dataAvailable.get() && this.stateReady.get()) {
            this.app.enqueue(() -> this.setupFabric());
        }
    }

    protected void setupFabric() {
        log.info("setupFabric()");
        try {
            log.info("getting fabrics...");
            FabricTypeData fabrics = this.session.getFabricTypeData();
            log.info("fabrics:" + fabrics);
            FabricTypeIndex.reset();
            FabricTypeIndex.initialize((FabricTypeData)fabrics);
            log.info("getting shapes...");
            SwatchShapeData shapes = this.session.getSwatchShapeData();
            log.info("shapes:" + shapes);
            SwatchShapeIndex.reset();
            SwatchShapeIndex.initialize((SwatchShapeData)shapes);
            this.networkState.trigger("success");
        }
        catch (Throwable t) {
            this.networkState.setFailed("Synching fabric data", t);
        }
        finally {
            log.info("Block finished.");
        }
    }

    protected void cleanupFabric() {
        log.info("cleanupFabric()");
        FabricTypeIndex.reset();
        SwatchShapeIndex.reset();
    }
}

