/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.item;

import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.texture.Texture;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.core.GuiMaterial;
import com.simsilica.lemur.geom.TbtQuad;
import mythruna.client.ui.Grid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemBorder {
    static Logger log = LoggerFactory.getLogger(ItemBorder.class);
    public static final ColorRGBA DEFAULT_COLOR = new ColorRGBA(0.2f, 0.2f, 0.1f, 0.5f);
    private int x = -1;
    private int y = -1;
    private int width;
    private int height;
    private Geometry border;
    private GuiMaterial material;
    private Grid parentGrid;
    private ColorRGBA color = DEFAULT_COLOR;

    public ItemBorder(int width, int height) {
        this.setSize(width, height);
    }

    public void setSize(int width, int height) {
        if (this.width == width && this.height == height) {
            return;
        }
        this.width = width;
        this.height = height;
        if (this.border != null) {
            this.border.removeFromParent();
        }
        TbtQuad quad = new TbtQuad((float)width, (float)height, 1, 1, 126, 126, 128, 128, 0.04f);
        this.border = new Geometry("itemBorder", (Mesh)quad);
        this.border.setQueueBucket(RenderQueue.Bucket.Transparent);
        Texture texture = GuiGlobals.getInstance().loadTexture("Interface/bordered-gradient.png", false, false);
        this.material = GuiGlobals.getInstance().createMaterial(texture, false);
        this.material.setColor(this.color);
        this.material.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.material.getMaterial().getAdditionalRenderState().setDepthWrite(false);
        this.border.setMaterial(this.material.getMaterial());
        this.border.setUserData("layer", (Object)2);
        this.resetPosition();
        if (this.parentGrid != null) {
            this.parentGrid.attachChild((Spatial)this.border);
        }
    }

    public void setColor(ColorRGBA color) {
        ColorRGBA colorRGBA = this.color = color == null ? DEFAULT_COLOR : color;
        if (this.material != null) {
            this.material.setColor(this.color);
        }
    }

    public void setPosition(int xSlot, int ySlot) {
        if (this.x == xSlot && this.y == ySlot) {
            return;
        }
        this.x = xSlot;
        this.y = ySlot;
        this.resetPosition();
    }

    protected void resetPosition() {
        this.border.setLocalTranslation((float)this.x, (float)(-this.y - this.height), 0.01f);
    }

    public void setParentGrid(Grid parentGrid) {
        if (this.parentGrid == parentGrid) {
            return;
        }
        this.parentGrid = parentGrid;
        if (parentGrid != null) {
            parentGrid.attachChild((Spatial)this.border);
        } else {
            this.border.removeFromParent();
        }
    }
}

