/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es.vars;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import java.util.Objects;
import mythruna.es.vars.IntVariable;
import mythruna.es.vars.LongVariable;
import mythruna.es.vars.StringVariable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalVars {
    static Logger log = LoggerFactory.getLogger(LocalVars.class);
    private static LoadingCache<InstanceKey, LocalVars> instances = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<InstanceKey, LocalVars>(){

        public LocalVars load(InstanceKey key) {
            return new LocalVars(key.entityId, key.ed);
        }
    });
    private EntityId entityId;
    private EntityData ed;

    protected LocalVars(EntityId entityId, EntityData ed) {
        this.entityId = entityId;
        this.ed = ed;
    }

    public static LocalVars get(EntityId entityId, EntityData ed) {
        return (LocalVars)instances.getUnchecked((Object)new InstanceKey(entityId, ed));
    }

    public static ComponentFilter filter(Class componentType, EntityId parent, int nameId) {
        ComponentFilter filter1 = Filters.fieldEquals((Class)componentType, (String)"parent", (Object)parent);
        ComponentFilter filter2 = Filters.fieldEquals((Class)componentType, (String)"nameId", (Object)nameId);
        return Filters.and((Class)componentType, (ComponentFilter[])new ComponentFilter[]{filter1, filter2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void store(int nameId, EntityComponent value) {
        ComponentFilter filter = LocalVars.filter(value.getClass(), this.entityId, nameId);
        LocalVars localVars = this;
        synchronized (localVars) {
            EntityId varId = this.ed.findEntity(filter, new Class[]{value.getClass()});
            if (varId == null) {
                varId = this.ed.createEntity();
            }
            this.ed.setComponent(varId, value);
        }
    }

    protected EntityId findEntity(String name, Class componentType) {
        int nameId = this.ed.getStrings().getStringId(name, false);
        if (nameId < 0) {
            return null;
        }
        ComponentFilter filter = LocalVars.filter(componentType, this.entityId, nameId);
        return this.ed.findEntity(filter, new Class[]{componentType});
    }

    public void storeInt(String name, int value) {
        int nameId = this.ed.getStrings().getStringId(name, true);
        this.store(nameId, new IntVariable(this.entityId, nameId, value));
    }

    public int loadInt(String name, int defaultValue) {
        EntityId varId = this.findEntity(name, IntVariable.class);
        if (varId == null) {
            return defaultValue;
        }
        IntVariable component = (IntVariable)this.ed.getComponent(varId, IntVariable.class);
        return component.getValue();
    }

    public void storeString(String name, String value) {
        int nameId = this.ed.getStrings().getStringId(name, true);
        this.store(nameId, new StringVariable(this.entityId, nameId, value));
    }

    public String loadString(String name, String defaultValue) {
        EntityId varId = this.findEntity(name, StringVariable.class);
        if (varId == null) {
            return defaultValue;
        }
        StringVariable component = (StringVariable)this.ed.getComponent(varId, StringVariable.class);
        return component.getValue();
    }

    public void storeLong(String name, long value) {
        int nameId = this.ed.getStrings().getStringId(name, true);
        this.store(nameId, new LongVariable(this.entityId, nameId, value));
    }

    public long loadLong(String name, long defaultValue) {
        EntityId varId = this.findEntity(name, LongVariable.class);
        if (varId == null) {
            return defaultValue;
        }
        LongVariable component = (LongVariable)this.ed.getComponent(varId, LongVariable.class);
        return component.getValue();
    }

    private static class InstanceKey {
        private EntityId entityId;
        private EntityData ed;

        public InstanceKey(EntityId entityId, EntityData ed) {
            this.entityId = entityId;
            this.ed = ed;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            InstanceKey other = (InstanceKey)o;
            if (other.ed != this.ed) {
                return false;
            }
            return Objects.equals(other.entityId, this.entityId);
        }

        public int hashCode() {
            return this.entityId.hashCode();
        }
    }
}

