/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.tile;

import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.simsilica.mworld.SedectileId;
import com.simsilica.mworld.TileId;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import mythruna.world.tile.Feature;
import mythruna.world.tile.FeatureId;
import mythruna.world.tile.SedectileData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sedectile
implements Serializable {
    static Logger log = LoggerFactory.getLogger(Sedectile.class);
    public static final int[][] DIR_MASKS = new int[3][3];
    private static final long serialVersionUID = 42L;
    private SedectileId id;
    private byte inFlags;
    private byte outFlags;
    private SetMultimap<TileId, FeatureId> featureIndex = MultimapBuilder.hashKeys().hashSetValues().build();
    private SedectileData data;
    private Map<Class, Object> generationStates = new HashMap<Class, Object>();

    public Sedectile(SedectileId id) {
        this.id = id;
    }

    public SedectileId getSedectileId() {
        return this.id;
    }

    public SedectileData getSedectileData() {
        if (this.data == null) {
            this.data = new SedectileData(this.id);
        }
        return this.data;
    }

    public void setGenerationState(Class generationType, Object state) {
        this.generationStates.put(generationType, state);
    }

    public <T> T getGenerationState(Class generationType, T defaultValue) {
        Object result = this.generationStates.get(generationType);
        return (T)(result == null ? defaultValue : result);
    }

    public static int getDirMask(int xRelative, int zRelative) {
        return DIR_MASKS[xRelative + 1][zRelative + 1];
    }

    public void setInFlags(int flags) {
        this.inFlags = (byte)(this.inFlags | flags);
    }

    public byte getInFlags() {
        return this.inFlags;
    }

    public void setOutFlags(int flags) {
        this.outFlags = (byte)(this.outFlags | flags);
    }

    public byte getOutFlags() {
        return this.outFlags;
    }

    public boolean hasInFlag(int mask) {
        return (this.inFlags & mask) != 0;
    }

    public boolean hasOutFlag(int mask) {
        return (this.outFlags & mask) != 0;
    }

    public boolean isOutComplete() {
        return this.outFlags == -1;
    }

    public boolean isComplete() {
        return this.outFlags == -1 && this.inFlags == -1;
    }

    public boolean addFeature(Feature<? extends Feature> feature) {
        int count = 0;
        for (TileId tileId : feature.getAffectedTiles()) {
            if (!Objects.equals(tileId.getSedectileId(), this.id)) continue;
            this.featureIndex.put((Object)tileId, feature.getFeatureId());
            ++count;
        }
        return count > 0;
    }

    public <T extends Feature> List<FeatureId<T>> getFeatureIds(TileId tileId, Class<T> featureType) {
        ArrayList<FeatureId<T>> results = new ArrayList<FeatureId<T>>();
        for (FeatureId id : this.featureIndex.get((Object)tileId)) {
            if (!featureType.isAssignableFrom(id.getType())) continue;
            results.add(id);
        }
        return results;
    }

    public String toString() {
        return "Sedectile[id=" + this.getSedectileId() + ", inFlags=" + Integer.toHexString(this.inFlags) + ", outFlags=" + Integer.toHexString(this.outFlags) + "]";
    }

    static {
        int mask = 1;
        for (int x = 0; x < 3; ++x) {
            for (int z = 0; z < 3; ++z) {
                if (x == 1 && z == 1) continue;
                Sedectile.DIR_MASKS[x][z] = mask;
                mask <<= 1;
            }
        }
    }
}

