/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CellGenType {
    None(0),
    Terrain(1),
    Insert(2),
    Flora(3);

    static Logger log;
    private static final int TYPE_BITS = 3;
    private static final int TYPE_SHIFT = 24;
    private static final int TYPE_MASK = 0x3000000;
    private int bits;
    private int mask;

    private CellGenType(int bits) {
        this.bits = bits;
        this.mask = bits << 24;
    }

    public int apply(int value) {
        return value | this.mask;
    }

    public int getBits() {
        return this.bits;
    }

    public static int getTypeBits(int value) {
        return value >> 24 & 3;
    }

    public static CellGenType getType(int value) {
        int b = CellGenType.getTypeBits(value);
        switch (b) {
            case 0: {
                return None;
            }
            case 1: {
                return Terrain;
            }
            case 2: {
                return Insert;
            }
            case 3: {
                return Flora;
            }
        }
        throw new IllegalArgumentException("Unknown type bits:" + b);
    }

    static {
        log = LoggerFactory.getLogger(CellGenType.class);
    }
}

