/*
 * Decompiled with CFR 0.152.
 */
package mythruna.fabric;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.Collection;
import java.util.Objects;
import mythruna.fabric.FabricType;
import mythruna.fabric.io.FabricTypeData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricTypeIndex {
    static Logger log = LoggerFactory.getLogger(FabricTypeIndex.class);
    private static FabricType[] types;
    private static int typeCount;
    private static FabricType badType;
    private static int badTypeIndex;
    private static Multimap<String, FabricType> variationIndex;

    private FabricTypeIndex() {
    }

    public static void initialize(FabricTypeData data) {
        FabricTypeIndex.initialize(data.types, data.badTypeIndex);
    }

    public static void initialize(FabricType[] types, int badTypeIndex) {
        log.info("initialize(size:" + types.length + ")");
        if (FabricTypeIndex.types != null) {
            throw new IllegalStateException("FabricTypeIndex is already initialized");
        }
        FabricTypeIndex.types = types;
        typeCount = types.length;
        FabricTypeIndex.badTypeIndex = badTypeIndex;
        badType = types[badTypeIndex];
        for (FabricType type : types) {
            if (type == null) continue;
            variationIndex.put((Object)type.getName(), (Object)type);
        }
    }

    public static FabricTypeData toData() {
        return new FabricTypeData(types, badTypeIndex);
    }

    public static void reset() {
        types = null;
        typeCount = 0;
        badTypeIndex = 0;
        badType = null;
        variationIndex.clear();
    }

    public static Collection<String> getNames() {
        return variationIndex.keySet();
    }

    public static Collection<FabricType> getVariations(String name) {
        return variationIndex.get((Object)name);
    }

    public static FabricType get(int type) {
        if (type >= 0 && type < typeCount) {
            return types[type];
        }
        return badType;
    }

    public static void setBadTypeIndex(int index) {
        badTypeIndex = index;
    }

    public static int getBadTypeIndex() {
        return badTypeIndex;
    }

    public static void override(int index, FabricType type) {
        FabricTypeIndex.types[index] = type;
    }

    public static boolean isInitialized() {
        return types != null;
    }

    public static int getTypeCount() {
        return typeCount;
    }

    public static FabricType[] getTypes() {
        return types;
    }

    public static int findType(String name, String variant) {
        return FabricTypeIndex.findType(name, variant, -1);
    }

    public static int findType(String name, String variant, int defaultValue) {
        for (int i = 0; i < types.length; ++i) {
            FabricType type = types[i];
            if (type == null || !Objects.equals(type.getName(), name) || !Objects.equals(type.getVariation(), variant)) continue;
            return i;
        }
        return defaultValue;
    }

    public static int findType(String fullName) {
        return FabricTypeIndex.findType(fullName, -1);
    }

    public static int findType(String fullName, int defaultValue) {
        for (int i = 0; i < types.length; ++i) {
            FabricType type = types[i];
            if (type == null || !Objects.equals(type.getFullName(), fullName)) continue;
            return i;
        }
        return -1;
    }

    static {
        variationIndex = MultimapBuilder.hashKeys().arrayListValues().build();
    }
}

