/**
 *  Script to clear out Holding components if they do not have an
 *  associated AttachedTo.
 *
 *  The HoldingSystem used to (incorrectly) remove the AttachedTo when the
 *  game was shutting down because the removeObject() was called on the container.
 *  Now it keeps AttachedTo in synch with Holding using listeners.
 */


def removeMismatchedHoldings = {
    log.info("All Holding entities...");

    findEntities(null, Holding.class).each {
        // See if this entity has the attach-back
        def item = findEntity(AttachedTo.filter(it, "hand.right", entityData), AttachedTo.class);
        if( item ) {
            // This character is already good
            return;
        }
        log.info(" **removing Holding component from:" + it);
        it.remove(Holding.class);
        logComponents(log, it, "    ", 80);
    }
}

// What is the existing structure version?
def versionKey = "holding.data.version";
def version = worldManager.worldEntity.vars.loadInt(versionKey, -1);
def latestVersion = 1;

log.info("Holding data version:" + version);
if( version < 1 ) {
    log.info("Need to upgrade holding data to match missing AttachedTo.");
    removeMismatchedHoldings();
}

if( version < latestVersion ) {
    // Mark it as upgraded
    log.info("Setting " + versionKey + " to:" + latestVersion);
    worldManager.worldEntity.vars.storeInt(versionKey, latestVersion);
}




