/*
 * Decompiled with CFR 0.152.
 */
package mythruna.character;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import mythruna.character.Pronouns;
import mythruna.text.CsvUtils;
import mythruna.text.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PronounsIndex {
    static Logger log = LoggerFactory.getLogger(PronounsIndex.class);
    public static final String BODY_TYPE_INDEX_CSV = "races/pronouns.csv";
    private Map<String, Pronouns> index = new HashMap<String, Pronouns>();

    public PronounsIndex(List<Pronouns> configs) {
        for (Pronouns config : configs) {
            this.index.put(config.getRaceId(), config);
            if (config.getRaceId().length() != 0) continue;
            this.index.put(null, config);
        }
    }

    public Pronouns get(String raceId) {
        return this.index.get(raceId);
    }

    public static PronounsIndex create(Function<String, String> textFunc) {
        String text = textFunc.apply(BODY_TYPE_INDEX_CSV);
        PronounsIndex index = PronounsIndex.create(text);
        return index;
    }

    public static PronounsIndex create(String text) {
        List<Map<String, String>> records = CsvUtils.csvToRecords(text, 0, '\t');
        List<Pronouns> configs = MapUtils.toObjects(records, Pronouns.class);
        return new PronounsIndex(configs);
    }
}

