/*
 * Decompiled with CFR 0.152.
 */
package mythruna.fabric;

import com.jme3.math.ColorRGBA;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.texture.image.ColorSpace;
import com.jme3.texture.image.ImageRaster;
import com.jme3.util.BufferUtils;
import com.simsilica.mblock.CellData;
import java.nio.ByteBuffer;
import mythruna.fabric.FabricPaintTarget;
import mythruna.fabric.FabricType;
import mythruna.fabric.FabricTypeIndex;
import mythruna.fabric.FabricUtils;
import mythruna.fabric.SwatchShape;
import mythruna.fabric.SwatchShapeIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClothingPainter
implements FabricPaintTarget {
    static Logger log = LoggerFactory.getLogger(ClothingPainter.class);
    private int width;
    private int height;
    private boolean supportAlpha;
    private Image diffuseImage;
    private Image normalImage;
    private Image specularImage;
    private Texture diffuseTexture;
    private Texture normalTexture;
    private Texture specularTexture;
    private ImageRaster diffuseRaster;
    private ImageRaster normalRaster;
    private ImageRaster specularRaster;

    public ClothingPainter() {
        this(1024, 1024, false);
    }

    public ClothingPainter(boolean supportAlpha) {
        this(1024, 1024, supportAlpha);
    }

    public ClothingPainter(int width, int height, boolean supportAlpha) {
        this.width = width;
        this.height = height;
        this.supportAlpha = supportAlpha;
        this.diffuseImage = ClothingPainter.createImage(width, height, supportAlpha);
        this.normalImage = ClothingPainter.createImage(width, height, supportAlpha);
        this.specularImage = ClothingPainter.createImage(width, height, true);
        this.diffuseTexture = new Texture2D(this.diffuseImage);
        this.normalTexture = new Texture2D(this.normalImage);
        this.specularTexture = new Texture2D(this.specularImage);
        this.diffuseRaster = ImageRaster.create((Image)this.diffuseImage);
        this.normalRaster = ImageRaster.create((Image)this.normalImage);
        this.specularRaster = ImageRaster.create((Image)this.specularImage);
        ColorRGBA defaultNormal = new ColorRGBA(0.5f, 0.5f, 1.0f, 0.0f);
        ClothingPainter.fillRaster(this.normalRaster, defaultNormal);
    }

    public static Image createImage(int width, int height, boolean supportAlpha) {
        int bytesPerPixel = supportAlpha ? 4 : 3;
        int size = width * height * bytesPerPixel;
        ByteBuffer data = BufferUtils.createByteBuffer((int)size);
        if (supportAlpha) {
            return new Image(Image.Format.ABGR8, width, height, data, ColorSpace.Linear);
        }
        return new Image(Image.Format.BGR8, width, height, data, ColorSpace.Linear);
    }

    public static void fillRaster(ImageRaster raster, ColorRGBA value) {
        int width = raster.getWidth();
        int height = raster.getHeight();
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < width; ++j) {
                raster.setPixel(i, j, value);
            }
        }
    }

    public void clearDiffuse(ColorRGBA value) {
        ClothingPainter.fillRaster(this.diffuseRaster, value);
    }

    public int getWidth() {
        return 1024;
    }

    public int getHeight() {
        return 1024;
    }

    protected int clamp(int val, int min, int max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public boolean repaint(CellData source, FabricType clear) {
        return this.repaint(source, clear, null);
    }

    public boolean repaint(CellData source, FabricType clear, boolean[][] changedCells) {
        boolean forceReset = changedCells == null;
        boolean changed = false;
        if (log.isTraceEnabled()) {
            log.trace("repaint()");
        }
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                int value;
                if (!forceReset && !changedCells[i][j]) continue;
                clear.paint(this, i * 32, j * 32, null);
                if (changedCells != null) {
                    changedCells[i][j] = false;
                }
                for (int k = 0; k < 32 && (value = source.getCell(i, j, k)) != 0; ++k) {
                    SwatchShape shape = SwatchShapeIndex.get(FabricUtils.toShape(value));
                    FabricType fabric = FabricTypeIndex.get(FabricUtils.toFabric(value));
                    fabric.paint(this, i * 32, j * 32, shape);
                    changed = true;
                }
            }
        }
        return changed;
    }

    @Override
    public void paint(int x, int y, ColorRGBA diffuse, ColorRGBA normal, ColorRGBA specular, float alpha) {
        ColorRGBA existing;
        x = this.clamp(x, 0, this.getWidth() - 1);
        y = this.clamp(y, 0, this.getHeight() - 1);
        if (alpha < 1.0f) {
            existing = this.diffuseRaster.getPixel(x, y);
            existing.interpolateLocal(diffuse, alpha);
            this.diffuseRaster.setPixel(x, y, existing);
        } else {
            this.diffuseRaster.setPixel(x, y, diffuse);
        }
        this.normalRaster.setPixel(x, y, normal);
        if (alpha < 1.0f) {
            existing = this.specularRaster.getPixel(x, y);
            existing.interpolateLocal(specular, alpha);
            this.specularRaster.setPixel(x, y, existing);
        } else {
            this.specularRaster.setPixel(x, y, specular);
        }
    }

    public Texture getDiffuseTexture() {
        return this.diffuseTexture;
    }

    public Texture getNormalTexture() {
        return this.normalTexture;
    }

    public Texture getSpecularTexture() {
        return this.specularTexture;
    }
}

