/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world;

import com.simsilica.mblock.BlockName;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mworld.CellGenType;
import com.simsilica.mworld.tile.TerrainTypeFunction;
import mythruna.world.TerrainTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageTypeFunction
implements TerrainTypeFunction {
    static Logger log = LoggerFactory.getLogger(ImageTypeFunction.class);
    private final int sandType = BlockTypeIndex.findType((BlockName)new BlockName("sand", "cube"), (int)1);
    private final int dirtType = BlockTypeIndex.findType((BlockName)new BlockName("dirt", "cube"), (int)1);
    private final int grassType = BlockTypeIndex.findType((BlockName)new BlockName("grass", "cube"), (int)1);
    private final int dryGrassType = BlockTypeIndex.findType((BlockName)new BlockName("dry-grass", "cube"), (int)1);
    private final int stone1Type = BlockTypeIndex.findType((BlockName)new BlockName("sandstone", "cube"), (int)1);
    private final int stone2Type = BlockTypeIndex.findType((BlockName)new BlockName("dark-granite", "cube"), (int)1);
    private final int stone3Type = BlockTypeIndex.findType((BlockName)new BlockName("bmarble", "cube"), (int)1);
    private final int stone4Type = BlockTypeIndex.findType((BlockName)new BlockName("stone", "cube"), (int)1);
    private final int stone5Type = BlockTypeIndex.findType((BlockName)new BlockName("wmarble", "cube"), (int)1);
    private final int snowType = BlockTypeIndex.findType((BlockName)new BlockName("snow", "cube"), (int)1);
    private final int iceType = BlockTypeIndex.findType((BlockName)new BlockName("ice", "cube"), (int)1);
    private final int TERRAIN_BITS = CellGenType.Terrain.getBits();

    public int apply(int existingTerrainType, int rawCellValue, int blockType) {
        int typeBits = CellGenType.getTypeBits((int)rawCellValue);
        if (typeBits != this.TERRAIN_BITS) {
            return -1;
        }
        int baseType = TerrainTypes.getBaseType(existingTerrainType);
        if (log.isTraceEnabled()) {
            log.trace("existing:" + Integer.toHexString(existingTerrainType) + "  baseType:" + Integer.toHexString(baseType) + "  block:" + blockType);
        }
        if (blockType == this.sandType) {
            if (baseType == 0) {
                log.trace("   using existing sand");
                return existingTerrainType;
            }
            return TerrainTypes.setBaseType(existingTerrainType, 0);
        }
        if (blockType == this.stone1Type) {
            if (baseType == 2) {
                log.trace("   using existing stone1");
                return existingTerrainType;
            }
            return TerrainTypes.setBaseType(existingTerrainType, 2);
        }
        if (blockType == this.stone2Type) {
            if (baseType == 3) {
                log.trace("   using existing stone2");
                return existingTerrainType;
            }
            return TerrainTypes.setBaseType(existingTerrainType, 3);
        }
        if (blockType == this.stone3Type) {
            if (baseType == 4) {
                log.trace("   using existing stone3");
                return existingTerrainType;
            }
            return TerrainTypes.setBaseType(existingTerrainType, 4);
        }
        if (blockType == this.stone4Type) {
            if (baseType == 5) {
                log.trace("   using existing stone4");
                return existingTerrainType;
            }
            return TerrainTypes.setBaseType(existingTerrainType, 5);
        }
        if (blockType == this.stone1Type) {
            if (baseType == 6) {
                log.trace("   using existing stone5");
                return existingTerrainType;
            }
            return TerrainTypes.setBaseType(existingTerrainType, 6);
        }
        if (blockType == this.iceType) {
            if (baseType == 7 && TerrainTypes.isFrozen(existingTerrainType)) {
                log.trace("   using existing ice");
                return existingTerrainType;
            }
            byte ice = TerrainTypes.setBaseType(existingTerrainType, 7);
            return TerrainTypes.setFrozen(existingTerrainType, -128);
        }
        if (blockType == this.snowType) {
            if (TerrainTypes.isFrozen(existingTerrainType)) {
                return existingTerrainType;
            }
            return TerrainTypes.setFrozen(existingTerrainType, -128);
        }
        if (blockType == this.dirtType) {
            int foliage;
            if (baseType == 1 && (foliage = TerrainTypes.getFoliageLevel(existingTerrainType)) == 0) {
                log.trace("   using existing dirt");
                return existingTerrainType;
            }
            byte result = TerrainTypes.setBaseType(existingTerrainType, 1);
            if (log.isTraceEnabled()) {
                log.trace("   changing foliage to 0");
            }
            result = TerrainTypes.setFoliageLevel(result, 0);
            if (log.isTraceEnabled()) {
                log.trace("   result:" + Integer.toHexString(result));
            }
            return result;
        }
        if (blockType == this.grassType) {
            int wetness;
            int foliage = TerrainTypes.getFoliageLevel(existingTerrainType);
            if (foliage == 0) {
                if (log.isTraceEnabled()) {
                    log.trace("   changing foliage to 1");
                }
                foliage = 1;
            }
            if ((wetness = TerrainTypes.getWetnessLevel(existingTerrainType)) < 1) {
                if (log.isTraceEnabled()) {
                    log.trace("   changing wetness to 1");
                }
                wetness = 1;
            }
            byte result = 1;
            result = TerrainTypes.setFoliageLevel(result, foliage);
            result = TerrainTypes.setWetnessLevel(result, wetness);
            if (log.isTraceEnabled()) {
                log.trace("   result:" + Integer.toHexString(result));
            }
            return result;
        }
        if (blockType == this.dryGrassType) {
            int wetness;
            int foliage = TerrainTypes.getFoliageLevel(existingTerrainType);
            if (foliage == 0) {
                if (log.isTraceEnabled()) {
                    log.trace("   changing foliage to 1");
                }
                foliage = 1;
            }
            if ((wetness = TerrainTypes.getWetnessLevel(existingTerrainType)) > 0) {
                if (log.isTraceEnabled()) {
                    log.trace("   changing wetness to 0");
                }
                wetness = 0;
            }
            byte result = 1;
            result = TerrainTypes.setFoliageLevel(result, foliage);
            result = TerrainTypes.setWetnessLevel(result, wetness);
            if (log.isTraceEnabled()) {
                log.trace("   result:" + Integer.toHexString(result));
            }
            return result;
        }
        return -1;
    }
}

