/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.river;

import com.simsilica.ethereal.io.BitInputStream;
import com.simsilica.ethereal.io.BitOutputStream;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.io.ObjectProtocol;
import java.io.IOException;
import mythruna.world.river.WaterBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaterBodyProtocol
implements ObjectProtocol<WaterBody> {
    static Logger log = LoggerFactory.getLogger(WaterBodyProtocol.class);
    public static final int X_BITS = 32;
    public static final int Y_BITS = 10;
    public static final int Z_BITS = 32;
    public static final int TYPE_BITS = 8;
    public static final int DEPTH_BITS = 6;
    public static final int RADIUS_BITS = 8;
    public static final int INFLUENCE_BITS = 10;
    public static final int CARVE_RADIUS_BITS = 8;
    public static final int CARVE_INFLUENCE_BITS = 10;
    public static final int VARIATION_BITS = 8;
    private int version = 0;

    public int getProtocolVersion() {
        return this.version;
    }

    public void write(WaterBody data, BitOutputStream out) throws IOException {
        out.writeBits(this.version, 8);
        out.writeBits(data.getType(), 8);
        Vec3i center = data.getCenter();
        out.writeBits(center.x, 32);
        out.writeBits(center.y, 10);
        out.writeBits(center.z, 32);
        out.writeBits(data.getDepth(), 6);
        out.writeBits(data.getRadius(), 8);
        out.writeBits(data.getInfluence(), 10);
        out.writeBits(data.getCarveElevation(), 10);
        out.writeBits(data.getCarveRadius(), 8);
        out.writeBits(data.getCarveInfluence(), 10);
        out.writeBits(data.getVariation(), 8);
    }

    public WaterBody read(BitInputStream in) throws IOException {
        int version = in.readBits(8);
        int type = in.readBits(8);
        int x = in.readBits(32);
        int y = in.readBits(10);
        int z = in.readBits(32);
        Vec3i center = new Vec3i(x, y, z);
        int depth = in.readBits(6);
        int radius = in.readBits(8);
        int influence = in.readBits(10);
        int carveElevation = in.readBits(10);
        int carveRadius = in.readBits(8);
        int carveInfluence = in.readBits(10);
        int variation = in.readBits(8);
        return new WaterBody(center, depth, radius, influence, carveElevation, carveRadius, carveInfluence, variation);
    }
}

