/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.base;

import com.jme3.network.Client;
import com.jme3.network.ClientStateListener;
import com.jme3.network.ErrorListener;
import com.jme3.network.Message;
import com.jme3.network.MessageListener;
import com.jme3.network.base.ConnectorAdapter;
import com.jme3.network.base.ConnectorFactory;
import com.jme3.network.base.MessageListenerRegistry;
import com.jme3.network.base.MessageProtocol;
import com.jme3.network.base.protocol.SerializerMessageProtocol;
import com.jme3.network.kernel.Connector;
import com.jme3.network.message.ChannelInfoMessage;
import com.jme3.network.message.ClientRegistrationMessage;
import com.jme3.network.message.DisconnectMessage;
import com.jme3.network.service.ClientServiceManager;
import com.jme3.network.service.serializer.ClientSerializerRegistrationsService;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultClient
implements Client {
    private static final Logger log = Logger.getLogger(DefaultClient.class.getName());
    private static final int CH_RELIABLE = 0;
    private static final int CH_UNRELIABLE = 1;
    private static final int CH_FIRST = 2;
    private final ThreadLocal<ByteBuffer> dataBuffer = new ThreadLocal();
    private int id = -1;
    private boolean isRunning = false;
    private final CountDownLatch connecting = new CountDownLatch(1);
    private String gameName;
    private int version;
    private final MessageListenerRegistry<Client> messageListeners = new MessageListenerRegistry();
    private final List<ClientStateListener> stateListeners = new CopyOnWriteArrayList<ClientStateListener>();
    private final List<ErrorListener<? super Client>> errorListeners = new CopyOnWriteArrayList<ErrorListener<? super Client>>();
    private final Redispatch dispatcher = new Redispatch();
    private final List<ConnectorAdapter> channels = new ArrayList<ConnectorAdapter>();
    private ConnectorFactory connectorFactory;
    private ClientServiceManager services;
    private MessageProtocol protocol = new SerializerMessageProtocol();

    public DefaultClient(String gameName, int version) {
        this.gameName = gameName;
        this.version = version;
        this.services = new ClientServiceManager(this);
        this.addStandardServices();
    }

    public DefaultClient(String gameName, int version, Connector reliable, Connector fast, ConnectorFactory connectorFactory) {
        this(gameName, version);
        this.setPrimaryConnectors(reliable, fast, connectorFactory);
    }

    protected void addStandardServices() {
        log.fine("Adding standard services...");
        this.services.addService(new ClientSerializerRegistrationsService());
    }

    protected void setPrimaryConnectors(Connector reliable, Connector fast, ConnectorFactory connectorFactory) {
        if (reliable == null) {
            throw new IllegalArgumentException("The reliable connector cannot be null.");
        }
        if (this.isRunning) {
            throw new IllegalStateException("Client is already started.");
        }
        if (!this.channels.isEmpty()) {
            throw new IllegalStateException("Channels already exist.");
        }
        this.connectorFactory = connectorFactory;
        this.channels.add(new ConnectorAdapter(reliable, this.protocol, this.dispatcher, this.dispatcher, true));
        if (fast != null) {
            this.channels.add(new ConnectorAdapter(fast, this.protocol, this.dispatcher, this.dispatcher, false));
        } else {
            this.channels.add(null);
        }
    }

    protected void checkRunning() {
        if (!this.isRunning) {
            throw new IllegalStateException("Client is not started.");
        }
    }

    @Override
    public void start() {
        if (this.isRunning) {
            throw new IllegalStateException("Client is already started.");
        }
        for (ConnectorAdapter ca : this.channels) {
            if (ca == null) continue;
            ca.start();
        }
        long tempId = System.currentTimeMillis() + System.nanoTime();
        this.isRunning = true;
        ClientRegistrationMessage reg = new ClientRegistrationMessage();
        reg.setId(tempId);
        reg.setGameName(this.getGameName());
        reg.setVersion(this.getVersion());
        reg.setReliable(true);
        this.send(0, reg, false);
        reg = new ClientRegistrationMessage();
        reg.setId(tempId);
        reg.setReliable(false);
        for (int ch = 1; ch < this.channels.size(); ++ch) {
            if (this.channels.get(ch) == null) continue;
            this.send(ch, reg, false);
        }
    }

    @Override
    public boolean isStarted() {
        return this.isRunning;
    }

    protected void waitForConnected() {
        if (this.isConnected()) {
            return;
        }
        try {
            this.connecting.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for connect", e);
        }
    }

    @Override
    public boolean isConnected() {
        return this.id != -1 && this.isRunning;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getGameName() {
        return this.gameName;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public ClientServiceManager getServices() {
        return this.services;
    }

    @Override
    public void send(Message message) {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "send({0})", message);
        }
        if (message.isReliable() || this.channels.get(1) == null) {
            this.send(0, message, true);
        } else {
            this.send(1, message, true);
        }
    }

    @Override
    public void send(int channel, Message message) {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "send({0}, {1})", new Object[]{channel, message});
        }
        if (channel >= 0) {
            this.waitForConnected();
        }
        if (channel < -2 || channel + 2 >= this.channels.size()) {
            throw new IllegalArgumentException("Channel is undefined:" + channel);
        }
        this.send(channel + 2, message, true);
    }

    protected void send(int channel, Message message, boolean waitForConnected) {
        ByteBuffer buffer;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "send({0}, {1}, {2})", new Object[]{channel, message, waitForConnected});
        }
        this.checkRunning();
        if (waitForConnected) {
            this.waitForConnected();
        }
        if ((buffer = this.dataBuffer.get()) == null) {
            buffer = ByteBuffer.allocate(65538);
            this.dataBuffer.set(buffer);
        }
        buffer.clear();
        buffer = this.protocol.toByteBuffer(message, buffer);
        byte[] temp = new byte[buffer.remaining()];
        System.arraycopy(buffer.array(), buffer.position(), temp, 0, buffer.remaining());
        buffer = ByteBuffer.wrap(temp);
        this.channels.get(channel).write(buffer);
    }

    @Override
    public void close() {
        this.checkRunning();
        this.closeConnections(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnections(ClientStateListener.DisconnectInfo info) {
        DefaultClient defaultClient = this;
        synchronized (defaultClient) {
            if (!this.isRunning) {
                return;
            }
            if (this.services.isStarted()) {
                this.services.stop();
            }
            for (ConnectorAdapter ca : this.channels) {
                if (ca == null) continue;
                ca.close();
            }
            this.connecting.countDown();
            this.isRunning = false;
            this.services.terminate();
        }
        this.fireDisconnected(info);
    }

    @Override
    public void addClientStateListener(ClientStateListener listener) {
        this.stateListeners.add(listener);
    }

    @Override
    public void removeClientStateListener(ClientStateListener listener) {
        this.stateListeners.remove(listener);
    }

    @Override
    public void addMessageListener(MessageListener<? super Client> listener) {
        this.messageListeners.addMessageListener(listener);
    }

    @Override
    public void addMessageListener(MessageListener<? super Client> listener, Class ... classes) {
        this.messageListeners.addMessageListener(listener, classes);
    }

    @Override
    public void removeMessageListener(MessageListener<? super Client> listener) {
        this.messageListeners.removeMessageListener(listener);
    }

    @Override
    public void removeMessageListener(MessageListener<? super Client> listener, Class ... classes) {
        this.messageListeners.removeMessageListener(listener, classes);
    }

    @Override
    public void addErrorListener(ErrorListener<? super Client> listener) {
        this.errorListeners.add(listener);
    }

    @Override
    public void removeErrorListener(ErrorListener<? super Client> listener) {
        this.errorListeners.remove(listener);
    }

    protected void fireConnected() {
        for (ClientStateListener l : this.stateListeners) {
            l.clientConnected(this);
        }
    }

    protected void startServices() {
        log.fine("Starting client services.");
        this.services.start();
    }

    protected void fireDisconnected(ClientStateListener.DisconnectInfo info) {
        for (ClientStateListener l : this.stateListeners) {
            l.clientDisconnected(this, info);
        }
    }

    protected void handleError(Throwable t) {
        if (this.errorListeners.isEmpty()) {
            log.log(Level.SEVERE, "Terminating connection due to unhandled error", t);
            ClientStateListener.DisconnectInfo info = new ClientStateListener.DisconnectInfo();
            info.reason = "Connection Error";
            info.error = t;
            this.closeConnections(info);
            return;
        }
        for (ErrorListener<? super Client> l : this.errorListeners) {
            l.handleError(this, t);
        }
    }

    protected void configureChannels(long tempId, int[] ports) {
        try {
            for (int i = 0; i < ports.length; ++i) {
                Connector c = this.connectorFactory.createConnector(i, ports[i]);
                ConnectorAdapter ca = new ConnectorAdapter(c, this.protocol, this.dispatcher, this.dispatcher, true);
                int ch = this.channels.size();
                this.channels.add(ca);
                ca.start();
                ClientRegistrationMessage reg = new ClientRegistrationMessage();
                reg.setId(tempId);
                reg.setReliable(true);
                this.send(ch, reg, false);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error configuring channels", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatch(Message m) {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "{0} received:{1}", new Object[]{this, m});
        }
        if (m instanceof ClientRegistrationMessage) {
            ClientRegistrationMessage crm = (ClientRegistrationMessage)m;
            if (crm.getId() >= 0L) {
                this.id = (int)crm.getId();
                log.log(Level.FINE, "Connection established, id:{0}.", this.id);
                this.connecting.countDown();
            } else {
                this.startServices();
                this.fireConnected();
            }
            return;
        }
        if (m instanceof ChannelInfoMessage) {
            this.configureChannels(((ChannelInfoMessage)m).getId(), ((ChannelInfoMessage)m).getPorts());
            return;
        }
        if (m instanceof DisconnectMessage) {
            String reason = ((DisconnectMessage)m).getReason();
            log.log(Level.SEVERE, "Connection terminated, reason:{0}.", reason);
            ClientStateListener.DisconnectInfo info = new ClientStateListener.DisconnectInfo();
            info.reason = reason;
            this.closeConnections(info);
        }
        DefaultClient defaultClient = this;
        synchronized (defaultClient) {
            this.messageListeners.messageReceived(this, m);
        }
    }

    protected class Redispatch
    implements MessageListener<Object>,
    ErrorListener<Object> {
        protected Redispatch() {
        }

        @Override
        public void messageReceived(Object source, Message m) {
            DefaultClient.this.dispatch(m);
        }

        @Override
        public void handleError(Object source, Throwable t) {
            DefaultClient.this.handleError(t);
        }
    }
}

