/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.fractal;

import com.google.common.base.MoreObjects;
import com.simsilica.fractal.Sampler;
import com.simsilica.fractal.SamplerRange;

public class Turbulence
implements Sampler {
    private Sampler noise;
    private double startingFrequency = 1.0;
    private int frequencyIterations = 5;
    private SamplerRange range = null;

    public Turbulence(Sampler noise) {
        this(noise, 5);
    }

    public Turbulence(Sampler noise, int frequencyIterations) {
        this.noise = noise;
        this.frequencyIterations = frequencyIterations;
    }

    public void setStartingFrequency(double startingFrequency) {
        this.startingFrequency = startingFrequency;
        this.range = null;
    }

    public double getStartingFrequency() {
        return this.startingFrequency;
    }

    public void setFrequencyIterations(int frequencyIterations) {
        this.frequencyIterations = frequencyIterations;
        this.range = null;
    }

    public int getFrequencyIterations() {
        return this.frequencyIterations;
    }

    @Override
    public double getSample(double x, double y, double z) {
        double value = 0.0;
        double f = this.startingFrequency;
        for (int i = 0; i < this.frequencyIterations; ++i) {
            double sample = Math.abs(this.noise.getSample(x * f, y * f, z * f)) / f;
            value += sample;
            f *= 2.0;
        }
        return value;
    }

    @Override
    public SamplerRange getRange() {
        if (this.range != null) {
            return this.range;
        }
        double f = this.startingFrequency;
        double min = Math.abs(this.noise.getRange().getMin());
        double max = Math.max(min, Math.abs(this.noise.getRange().getMax()));
        double maxResult = 0.0;
        for (int i = 0; i < this.frequencyIterations; ++i) {
            maxResult += max / f;
            f *= 2.0;
        }
        return new SamplerRange(0.0, maxResult);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("noise", (Object)this.noise).add("startingFrequence", this.startingFrequency).add("frequencyIterations", this.frequencyIterations).toString();
    }
}

