/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es;

import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.GridComponentIndex;
import com.simsilica.mathd.Vec3d;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SpatialEntityContainer<T, C extends EntityComponent>
extends EntityContainer<T> {
    static Logger log = LoggerFactory.getLogger(SpatialEntityContainer.class);
    private GridComponentIndex<C> gridIndex;
    private ComponentFilter<C> positionFilter;

    @SafeVarargs
    protected SpatialEntityContainer(GridComponentIndex<C> gridIndex, EntityData ed, Class<? extends EntityComponent> ... componentTypes) {
        super(ed, null, (Class[])componentTypes);
        this.gridIndex = gridIndex;
        gridIndex.validate(componentTypes);
        this.updateSpatialFilter(null);
    }

    public ComponentFilter<C> getPositionFilter() {
        return this.positionFilter;
    }

    protected void updateSpatialFilter(ComponentFilter<C> filter) {
        if (filter == null) {
            filter = this.gridIndex.createFalseFilter();
            this.positionFilter = null;
        } else {
            this.positionFilter = filter;
        }
        super.setFilter(filter);
    }

    protected void setFilter(ComponentFilter filter) {
        throw new UnsupportedOperationException("SpatialEntityContainer manages its own filter");
    }

    public boolean setCenter(Vec3d center, boolean forceUpdate) {
        boolean changed = this.gridIndex.setCenter(center, forceUpdate);
        if (changed) {
            this.updateSpatialFilter(this.gridIndex.getIndexFilter());
        }
        return changed;
    }
}

