/*
 * Decompiled with CFR 0.152.
 */
package mythruna.server;

import com.simsilica.action.ActionEnvironment;
import com.simsilica.action.ObjectTypeRegistry;
import com.simsilica.net.ChatSessionListener;
import com.simsilica.sim.GameSystemManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import mythruna.server.GameServer;
import mythruna.server.ServerLauncher;
import mythruna.server.SshdShellAdapter;
import mythruna.shell.AbstractShellCommand;
import mythruna.shell.CommandShell;
import mythruna.shell.Say;
import mythruna.shell.ShellCommand;
import mythruna.shell.ShellService;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.config.keys.AuthorizedKeysAuthenticator;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshdConsoleServer {
    static Logger log = LoggerFactory.getLogger(SshdConsoleServer.class);
    private ServerLauncher launcher;
    private GameServer gameServer;
    private GameSystemManager systems;
    private CommandShell adminShell;
    private SshServer sshd;
    private Map<CommandShell, ChatForwarder> chatListeners = new HashMap<CommandShell, ChatForwarder>();

    public SshdConsoleServer(ServerLauncher launcher, GameServer gameServer, CommandShell adminShell) {
        this.launcher = launcher;
        this.gameServer = gameServer;
        this.systems = gameServer.getSystems();
        this.sshd = SshServer.setUpDefaultServer();
        this.adminShell = adminShell;
        this.sshd.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider(Paths.get("hostkey.ser", new String[0])));
        File authorizedKeysFile = new File("authorized_keys");
        this.sshd.setPublickeyAuthenticator((PublickeyAuthenticator)new AuthorizedKeysAuthenticator(authorizedKeysFile.toPath()));
        this.sshd.setShellFactory(channel -> {
            log.info("channel:" + channel);
            return this.createShellAdapter(channel.getSession().getUsername());
        });
    }

    public void setPort(int port) {
        this.sshd.setPort(port);
    }

    protected CommandShell getCommandShell(String userId) {
        ObjectTypeRegistry objectTypes = (ObjectTypeRegistry)this.systems.get(ObjectTypeRegistry.class);
        ActionEnvironment actionEnv = new ActionEnvironment(objectTypes, null);
        CommandShell shell = ((ShellService)this.systems.get(ShellService.class)).getShell((Object)userId);
        if (shell == null) {
            shell = new CommandShell(this.adminShell, actionEnv, null);
            ((ShellService)this.systems.get(ShellService.class)).setShell((Object)userId, shell);
            Say say = new Say(text -> this.gameServer.postChatMessage(userId, text));
            this.adminShell.updateCommand("say", (ShellCommand)say);
            this.adminShell.updateCommand("'", (ShellCommand)say);
            this.adminShell.updateCommand("shutdown", (ShellCommand)new AbstractShellCommand(this, new String[]{"gracefully shuts down this server"}){

                public Object execute(CommandShell shell, String args) {
                    System.exit(0);
                    return null;
                }
            });
        }
        return shell;
    }

    protected SshdShellAdapter createShellAdapter(String userId) {
        CommandShell shell = this.getCommandShell(userId);
        SshdShellAdapter adapter = new SshdShellAdapter(arg_0 -> ((CommandShell)shell).execute(arg_0), a -> this.cleanupShell(userId, shell));
        shell.setOutput(o -> {
            log.info("shell output:" + o);
            adapter.println((String)o);
        });
        ChatForwarder forwarder = new ChatForwarder(this, adapter);
        this.gameServer.addChatSessionListener((ChatSessionListener)forwarder);
        return adapter;
    }

    protected void cleanupShell(String userId, CommandShell shell) {
        CommandShell current = ((ShellService)this.systems.get(ShellService.class)).getShell((Object)userId);
        if (current == shell) {
            log.info("Closing shell for:" + userId);
            ((ShellService)this.systems.get(ShellService.class)).removeShell((Object)userId);
            ChatForwarder forwarder = this.chatListeners.get(shell);
            if (forwarder != null) {
                this.gameServer.removeChatSessionListener((ChatSessionListener)forwarder);
            }
        }
    }

    public void start() {
        try {
            this.sshd.start();
            log.info("SSH server started on port " + this.sshd.getPort());
        }
        catch (IOException e) {
            log.error("Error starting SSHD", (Throwable)e);
        }
    }

    public void stop() {
        try {
            log.info("Shutting down SSHD");
            this.sshd.stop();
        }
        catch (IOException e) {
            log.error("Error shutton down SSHD", (Throwable)e);
        }
    }

    private class ChatForwarder
    implements ChatSessionListener {
        private SshdShellAdapter shellAdapter;

        public ChatForwarder(SshdConsoleServer sshdConsoleServer, SshdShellAdapter shellAdapter) {
            this.shellAdapter = shellAdapter;
        }

        protected String prefix(int clientId, String playerName) {
            return String.format("chat> %s@%d", playerName, clientId);
        }

        public void playerJoined(int clientId, String playerName) {
            log.info(this + ":playerJoined(" + clientId + ", " + playerName + ")");
            this.shellAdapter.println(this.prefix(clientId, playerName) + " has joined.");
        }

        public void newMessage(int clientId, String playerName, String message) {
            this.shellAdapter.println(this.prefix(clientId, playerName) + " said:" + message);
        }

        public void playerLeft(int clientId, String playerName) {
            log.info(this + ":playerLeft(" + clientId + ", " + playerName + ")");
            this.shellAdapter.println(this.prefix(clientId, playerName) + " has left.");
        }
    }
}

