/*
 * Decompiled with CFR 0.152.
 */
package mythruna.text;

import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvUtils {
    static Logger log = LoggerFactory.getLogger(CsvUtils.class);

    public static Map<String, Map<String, String>> csvToMap(String text, int headerRow, String keyField, char delimiter) {
        List<Map<String, String>> records = CsvUtils.csvToRecords(text, headerRow, delimiter);
        LinkedHashMap<String, Map<String, String>> result = new LinkedHashMap<String, Map<String, String>>();
        for (Map<String, String> record : records) {
            String id = record.get(keyField);
            if (Strings.isNullOrEmpty((String)id)) continue;
            result.put(id, record);
        }
        return result;
    }

    public static List<Map<String, String>> csvToRecords(String text, int headerRow, char delimiter) {
        List<List<String>> rows = CsvUtils.csvToRows(text, delimiter);
        if (rows.size() <= headerRow) {
            throw new IllegalArgumentException("CSV doew not have enough rows to find header row:" + headerRow);
        }
        List<String> header = rows.get(headerRow);
        ArrayList<Map<String, String>> records = new ArrayList<Map<String, String>>();
        for (int i = headerRow + 1; i < rows.size(); ++i) {
            List<String> row = rows.get(i);
            HashMap<String, String> record = new HashMap<String, String>();
            for (int j = 0; j < row.size(); ++j) {
                record.put(header.get(j), row.get(j));
            }
            if (record.isEmpty()) continue;
            records.add(record);
        }
        return records;
    }

    public static List<List<String>> csvToRows(String text, char delimiter) {
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        try (BufferedReader in = new BufferedReader(new StringReader(text));){
            String line;
            while ((line = in.readLine()) != null) {
                int length = line.length();
                if (length == 0) continue;
                ArrayList<String> row = new ArrayList<String>();
                rows.add(row);
                int start = 0;
                for (int i = 0; i < length; ++i) {
                    char c = line.charAt(i);
                    if (c != delimiter) continue;
                    String value = line.substring(start, i);
                    row.add(CsvUtils.cleanValue(value));
                    start = i + 1;
                }
                if (start >= length) continue;
                String value = line.substring(start);
                row.add(CsvUtils.cleanValue(value));
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Bad CSV format", e);
        }
        return rows;
    }

    public static String cleanValue(String value) {
        if (value.indexOf(8217) < 0) {
            return value;
        }
        int length = value.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (c == '\u2019') {
                c = '\'';
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

