/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es;

import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.Filters;
import com.simsilica.es.PersistentComponent;
import com.simsilica.es.StringType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Name
implements EntityComponent,
PersistentComponent {
    static Logger log = LoggerFactory.getLogger(Name.class);
    @StringType(maxLength=80)
    private String name;

    public Name() {
    }

    public Name(String name) {
        this(name, false);
    }

    public Name(String name, boolean truncate) {
        if (name.length() >= 80) {
            if (truncate) {
                log.info("Truncating name, exceeds 80 characters:" + name);
                name = name.substring(0, 77) + "...";
            } else {
                throw new IllegalArgumentException("Name exceeds 80 characters:" + name);
            }
        }
        this.name = name;
    }

    public static ComponentFilter<Name> filter(String name) {
        return Filters.fieldEquals(Name.class, "name", name);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "Name[" + this.name + "]";
    }
}

