/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.theora;

import de.jarnbjo.theora.CodingMode;
import de.jarnbjo.theora.CoeffNode;
import de.jarnbjo.theora.Constants;
import de.jarnbjo.theora.Coordinate;
import de.jarnbjo.theora.Header;
import de.jarnbjo.theora.HuffEntry;
import de.jarnbjo.theora.MotionVector;
import de.jarnbjo.util.io.BitInputStream;
import java.io.IOException;
import java.util.Arrays;

public class PbInstance {
    Header info;
    int keyframeGranuleShift;
    int decoderErrorCode;
    int framesHaveBeenSkipped;
    int postProcessEnabled;
    int postProcessingLevel;
    CodingMode codingMode;
    byte frameType;
    byte keyFrameType;
    int qualitySetting;
    int frameQIndex;
    int thisFrameQualityValue;
    int lastFrameQualityValue;
    int codedBlockIndex;
    int codedBlocksThisFrame;
    int frameSize;
    int yPlaneSize;
    int uvPlaneSize;
    int yStride;
    int uvStride;
    int vFragments;
    int hFragments;
    int unitFragments;
    int yPlaneFragments;
    int uvPlaneFragments;
    int reconYPlaneSize;
    int reconUVPlaneSize;
    int yDataOffset;
    int uDataOffset;
    int vDataOffset;
    int reconYDataOffset;
    int reconUDataOffset;
    int reconVDataOffset;
    int ySuperBlocks;
    int uvSuperBlocks;
    int superBlocks;
    int ysbRows;
    int ysbCols;
    int uvsbRows;
    int uvsbCols;
    int yMacroBlocks;
    int uvMacroBlocks;
    int macroBlocks;
    byte[] thisFrameRecon;
    byte[] goldenFrame;
    byte[] lastFrameRecon;
    byte[] postProcessBuffer;
    int[] pixelIndexTable;
    int[] reconPixelIndexTable;
    byte[] displayFragments;
    byte[] skippedDisplayFragments;
    int[] codedBlockList;
    MotionVector[] fragMVect;
    int[] fragTokenCounts;
    int[][] tokenList = new int[128][];
    int[] fragmentVariances;
    int[] fragQIndex;
    short[][] ppCoefBuffer = new short[64][];
    byte[] fragCoeffs;
    byte[] fragCoefEOB;
    short[][] qFragData = new short[64][];
    CodingMode[] fragCodingMethod;
    CoeffNode[] _nodes;
    int[] transIndex;
    int bumpLast;
    int[][][] blockMap;
    byte[] sbCodedFlags;
    byte[] sbFullyFlags;
    byte[] mbCodedFlags;
    byte[] mbFullyFlags;
    int eobRun;
    Coordinate[] fragCoordinates;
    MotionVector mVector;
    int reconPtr2Offset;
    short[] quantizedList;
    short[] reconDataBuffer;
    short invLastIntraDC;
    short invLastInterDC;
    short lastIntraDC;
    short lastInterDC;
    int blocksToDecode;
    int dcHuffChoice;
    byte acHuffChoice;
    int quadMBListIndex;
    int byteCount;
    int bitPattern;
    byte bitsSoFar;
    byte nextBit;
    int bitsLeft;
    short[] dequantBuffer;
    int[] fpQuantInterUvCoeffs = new int[64];
    int[] fpQuantInterUvRound = new int[64];
    int[] fpZeroBinSizeInterUv = new int[64];
    short[] tmpReconBuffer;
    short[] tmpDataBuffer;
    int[] filtBoundingValue = new int[512];
    int[] qThreshTable = new int[64];
    short[] dequantInterUvCoeffs;
    int[] quantIndex = new int[64];
    int[] quantYCoeffs = new int[64];
    int[] quantUvCoeffs = new int[64];
    int[] fpQuantYCoeffs = new int[64];
    HuffEntry[] huffRootVP3x;
    int[][] huffCodeArrayVP3x;
    byte[][] huffCodeLengthArrayVP3x;
    byte[][] extraBitLengthsVP3x;
    int[] fpQuantUvCoeffs = new int[64];
    int[] fpQuantInterCoeffs = new int[64];
    int[] fpQuantYRound = new int[64];
    int[] fpQuantUvRound = new int[64];
    int[] fpQuantInterRound = new int[64];
    int[] fpZeroBinSizeY = new int[64];
    int[] fpZeroBinSizeUv = new int[64];
    int[] fpZeroBinSizeInter = new int[64];
    int[] fquantCoeffs;
    int[] fquantRound;
    int[] fquantZbSize;
    short[] dequantYCoeffs;
    short[] dequantUvCoeffs;
    short[] dequantInterCoeffs;
    short[] dequantCoeffs;
    byte blockPatternPredictor;
    short[][] modifier = new short[4][512];
    int[][] modifierPointer = new int[4][2];
    byte[] dataOutputInPtr;

    public PbInstance(Header header) {
        this.info = header;
        this.reconDataBuffer = new short[64];
        this.dequantBuffer = new short[64];
        this.tmpDataBuffer = new short[64];
        this.tmpReconBuffer = new short[64];
        this.dequantYCoeffs = new short[64];
        this.dequantUvCoeffs = new short[64];
        this.dequantInterCoeffs = new short[64];
        this.dequantInterUvCoeffs = new short[64];
        this.modifierPointer[0][0] = 0;
        this.modifierPointer[0][1] = 255;
        this.modifierPointer[1][0] = 1;
        this.modifierPointer[1][1] = 255;
        this.modifierPointer[2][0] = 2;
        this.modifierPointer[2][1] = 255;
        this.modifierPointer[3][0] = 3;
        this.modifierPointer[3][1] = 255;
        this.decoderErrorCode = 0;
        this.keyFrameType = 0;
        this.framesHaveBeenSkipped = 0;
    }

    void initFrameDetails() {
        this.postProcessingLevel = 0;
        this.yPlaneSize = this.info.getWidth() * this.info.getHeight();
        this.uvPlaneSize = this.yPlaneSize / 4;
        this.hFragments = this.info.getWidth() / 8;
        this.vFragments = this.info.getHeight() / 8;
        this.unitFragments = this.vFragments * this.hFragments * 3 / 2;
        this.yPlaneFragments = this.hFragments * this.vFragments;
        this.uvPlaneFragments = this.yPlaneFragments / 4;
        this.yStride = this.info.getWidth() + 32;
        this.uvStride = this.yStride / 2;
        this.reconYPlaneSize = this.yStride * (this.info.getHeight() + 32);
        this.reconUVPlaneSize = this.reconYPlaneSize / 4;
        int frameSize = this.reconYPlaneSize + 2 * this.reconUVPlaneSize;
        this.yDataOffset = 0;
        this.uDataOffset = this.yPlaneSize;
        this.vDataOffset = this.yPlaneSize + this.uvPlaneSize;
        this.reconYDataOffset = this.yStride * 16 + 16;
        this.reconUDataOffset = this.reconYPlaneSize + this.uvStride * 8 + 8;
        this.reconVDataOffset = this.reconYPlaneSize + this.reconUVPlaneSize + this.uvStride * 8 + 8;
        this.ysbRows = this.info.getHeight() / 32 + (this.info.getHeight() % 32 > 0 ? 1 : 0);
        this.ysbCols = this.info.getWidth() / 32 + (this.info.getWidth() % 32 > 0 ? 1 : 0);
        this.uvsbRows = this.info.getHeight() / 2 / 32 + (this.info.getHeight() / 2 % 32 > 0 ? 1 : 0);
        this.uvsbCols = this.info.getWidth() / 2 / 32 + (this.info.getWidth() / 2 % 32 > 0 ? 1 : 0);
        this.ySuperBlocks = this.ysbRows * this.ysbCols;
        this.uvSuperBlocks = this.uvsbRows * this.uvsbCols;
        this.superBlocks = this.ySuperBlocks + 2 * this.uvSuperBlocks;
        this.yMacroBlocks = (this.vFragments + 1) / 2 * ((this.hFragments + 1) / 2);
        this.uvMacroBlocks = (this.vFragments / 2 + 1) / 2 * ((this.hFragments / 2 + 1) / 2);
        this.macroBlocks = this.yMacroBlocks + 2 * this.uvMacroBlocks;
        this.initFragmentInfo();
        this.initFrameInfo(frameSize);
        this.initializeFragCoordinates();
        this.createBlockMapping();
        this.calcPixelIndexTable();
    }

    void initFragmentInfo() {
        this.displayFragments = new byte[this.unitFragments];
        this.pixelIndexTable = new int[this.unitFragments];
        this.reconPixelIndexTable = new int[this.unitFragments];
        this.fragTokenCounts = new int[this.unitFragments];
        this.codedBlockList = new int[this.unitFragments];
        this.fragMVect = new MotionVector[this.unitFragments];
        this.fragCoefEOB = new byte[this.unitFragments];
        this.skippedDisplayFragments = new byte[this.unitFragments];
        this.qFragData = new short[this.unitFragments][];
        this.tokenList = new int[this.unitFragments][];
        this.fragCodingMethod = new CodingMode[this.unitFragments];
        this.fragCoordinates = new Coordinate[this.unitFragments];
        this.fragQIndex = new int[this.unitFragments];
        this.ppCoefBuffer = new short[this.unitFragments][];
        this.fragmentVariances = new int[this.unitFragments];
        this._nodes = new CoeffNode[this.unitFragments];
        this.sbCodedFlags = new byte[this.superBlocks];
        this.sbFullyFlags = new byte[this.superBlocks];
        this.mbCodedFlags = new byte[this.macroBlocks];
        this.mbFullyFlags = new byte[this.macroBlocks];
        this.blockMap = new int[this.superBlocks][4][4];
    }

    void initFrameInfo(int frameSize) {
        this.thisFrameRecon = new byte[frameSize];
        this.goldenFrame = new byte[frameSize];
        this.lastFrameRecon = new byte[frameSize];
        this.postProcessBuffer = new byte[frameSize];
    }

    void initializeFragCoordinates() {
        int thisFrag;
        int j;
        int i;
        int horizFrags = this.hFragments;
        int vertFrags = this.vFragments;
        int startFrag = 0;
        for (i = 0; i < vertFrags; ++i) {
            for (j = 0; j < horizFrags; ++j) {
                thisFrag = i * horizFrags + j;
                this.fragCoordinates[thisFrag] = new Coordinate();
                this.fragCoordinates[thisFrag].x = j * 8;
                this.fragCoordinates[thisFrag].y = i * 8;
            }
        }
        horizFrags >>= 1;
        vertFrags >>= 1;
        startFrag = this.yPlaneFragments;
        for (i = 0; i < vertFrags; ++i) {
            for (j = 0; j < horizFrags; ++j) {
                thisFrag = startFrag + i * horizFrags + j;
                this.fragCoordinates[thisFrag] = new Coordinate();
                this.fragCoordinates[thisFrag].x = j * 8;
                this.fragCoordinates[thisFrag].y = i * 8;
            }
        }
        startFrag = this.yPlaneFragments + this.uvPlaneFragments;
        for (i = 0; i < vertFrags; ++i) {
            for (j = 0; j < horizFrags; ++j) {
                thisFrag = startFrag + i * horizFrags + j;
                this.fragCoordinates[thisFrag] = new Coordinate();
                this.fragCoordinates[thisFrag].x = j * 8;
                this.fragCoordinates[thisFrag].y = i * 8;
            }
        }
    }

    void createBlockMapping() {
        for (int i = 0; i < this.ySuperBlocks + this.uvSuperBlocks * 2; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.blockMap[i][j][0] = -1;
                this.blockMap[i][j][1] = -1;
                this.blockMap[i][j][2] = -1;
                this.blockMap[i][j][3] = -1;
            }
        }
        this.createMapping(0, 0, this.hFragments, this.vFragments);
        this.createMapping(this.ySuperBlocks, this.hFragments * this.vFragments, this.hFragments / 2, this.vFragments / 2);
        this.createMapping(this.ySuperBlocks + this.uvSuperBlocks, this.hFragments * this.vFragments * 5 / 4, this.hFragments / 2, this.vFragments / 2);
    }

    void createMapping(int firstSb, int firstFrag, int hFrags, int vFrags) {
        int i = 0;
        int j = 0;
        int sb = firstSb;
        int fragIndex = firstFrag;
        int sbRows = vFrags / 4 + (vFrags % 4 != 0 ? 1 : 0);
        int sbCols = hFrags / 4 + (hFrags % 4 != 0 ? 1 : 0);
        for (int sbRow = 0; sbRow < sbRows; ++sbRow) {
            for (int sbCol = 0; sbCol < sbCols; ++sbCol) {
                int ypos = sbRow << 2;
                for (i = 0; i < 4 && ypos < vFrags; ++i, ++ypos) {
                    int xpos = sbCol << 2;
                    for (j = 0; j < 4 && xpos < hFrags; ++j, ++xpos) {
                        int mb;
                        if (i < 2) {
                            mb = j < 2 ? 0 : 1;
                        } else {
                            int n = mb = j < 2 ? 2 : 3;
                        }
                        int b = i % 2 != 0 ? (j % 2 != 0 ? 3 : 2) : (j % 2 != 0 ? 1 : 0);
                        this.blockMap[sb][mb][b] = fragIndex++;
                    }
                    fragIndex += hFrags - j;
                }
                ++sb;
                fragIndex -= i * hFrags - j;
            }
            fragIndex += 3 * hFrags;
        }
    }

    void calcPixelIndexTable() {
        int i;
        int[] pixelIndexTablePtr = this.pixelIndexTable;
        for (i = 0; i < this.yPlaneFragments; ++i) {
            pixelIndexTablePtr[i] = i / this.hFragments * 8 * this.info.getWidth() + i % this.hFragments * 8;
        }
        int offset = this.yPlaneFragments;
        for (i = 0; i < (this.hFragments >> 1) * this.vFragments; ++i) {
            pixelIndexTablePtr[i + offset] = i / (this.hFragments / 2) * (8 * this.info.getWidth() / 2) + i % (this.hFragments / 2) * 8 + this.yPlaneSize;
        }
        pixelIndexTablePtr = this.reconPixelIndexTable;
        for (i = 0; i < this.yPlaneFragments; ++i) {
            pixelIndexTablePtr[i] = i / this.hFragments * 8 * this.yStride + i % this.hFragments * 8 + this.reconYDataOffset;
        }
        for (i = 0; i < this.uvPlaneFragments; ++i) {
            pixelIndexTablePtr[i + offset] = i / (this.hFragments / 2) * (8 * this.uvStride) + i % (this.hFragments / 2) * 8 + this.reconUDataOffset;
        }
        offset = this.yPlaneFragments + this.uvPlaneFragments;
        for (i = 0; i < this.uvPlaneFragments; ++i) {
            pixelIndexTablePtr[i + offset] = i / (this.hFragments / 2) * (8 * this.uvStride) + i % (this.hFragments / 2) * 8 + this.reconVDataOffset;
        }
    }

    void initQTables() {
        System.arraycopy(Constants.qThreshTableV1, 0, this.qThreshTable, 0, this.qThreshTable.length);
    }

    void initHuffmanSet() {
        this.huffRootVP3x = new HuffEntry[80];
        this.huffCodeArrayVP3x = new int[80][];
        this.huffCodeLengthArrayVP3x = new byte[80][];
        this.extraBitLengthsVP3x = new byte[80][];
        for (int i = 0; i < 80; ++i) {
            this.huffCodeArrayVP3x[i] = new int[32];
            this.huffCodeLengthArrayVP3x[i] = new byte[32];
            this.extraBitLengthsVP3x[i] = new byte[32];
            this.buildHuffmanTree(this.huffRootVP3x, this.huffCodeArrayVP3x[i], this.huffCodeLengthArrayVP3x[i], i, Constants.frequencyCountsVP31[i]);
        }
    }

    void buildHuffmanTree(HuffEntry[] huffRoot, int[] huffCodeArray, byte[] huffCodeLengthArray, int hIndex, int[] freqList) {
        this.createHuffmanList(huffRoot, hIndex, freqList);
        while (huffRoot[hIndex].next != null) {
            HuffEntry entryPtr = new HuffEntry();
            entryPtr.value = -1;
            entryPtr.frequency = huffRoot[hIndex].frequency + huffRoot[hIndex].next.frequency;
            entryPtr.zeroChild = huffRoot[hIndex];
            entryPtr.oneChild = huffRoot[hIndex].next;
            if (entryPtr.oneChild.next != null) {
                huffRoot[hIndex] = entryPtr.oneChild.next;
                huffRoot[hIndex].previous = null;
                if (entryPtr.frequency <= huffRoot[hIndex].frequency) {
                    entryPtr.next = huffRoot[hIndex];
                    huffRoot[hIndex].previous = entryPtr;
                    entryPtr.previous = null;
                    huffRoot[hIndex] = entryPtr;
                } else {
                    HuffEntry searchPtr = huffRoot[hIndex];
                    while (searchPtr.next != null && searchPtr.frequency < entryPtr.frequency) {
                        searchPtr = searchPtr.next;
                    }
                    if (searchPtr.frequency < entryPtr.frequency) {
                        entryPtr.next = null;
                        entryPtr.previous = searchPtr;
                        searchPtr.next = entryPtr;
                    } else {
                        entryPtr.next = searchPtr;
                        entryPtr.previous = searchPtr.previous;
                        searchPtr.previous.next = entryPtr;
                        searchPtr.previous = entryPtr;
                    }
                }
            } else {
                entryPtr.next = null;
                entryPtr.previous = null;
                huffRoot[hIndex] = entryPtr;
            }
            entryPtr.zeroChild.next = null;
            entryPtr.zeroChild.previous = null;
            entryPtr.oneChild.next = null;
            entryPtr.oneChild.previous = null;
        }
        this.createCodeArray(huffRoot[hIndex], huffCodeArray, huffCodeLengthArray, 0, (byte)0);
    }

    void createHuffmanList(HuffEntry[] huffRoot, int hIndex, int[] freqList) {
        huffRoot[hIndex] = new HuffEntry();
        huffRoot[hIndex].previous = null;
        huffRoot[hIndex].next = null;
        huffRoot[hIndex].zeroChild = null;
        huffRoot[hIndex].oneChild = null;
        huffRoot[hIndex].value = 0;
        huffRoot[hIndex].frequency = freqList[0];
        if (huffRoot[hIndex].frequency == 0) {
            huffRoot[hIndex].frequency = 1;
        }
        for (int i = 1; i < 32; ++i) {
            HuffEntry entryPtr = new HuffEntry();
            entryPtr.value = i;
            entryPtr.frequency = freqList[i];
            entryPtr.zeroChild = null;
            entryPtr.oneChild = null;
            if (entryPtr.frequency == 0) {
                entryPtr.frequency = 1;
            }
            if (entryPtr.frequency <= huffRoot[hIndex].frequency) {
                entryPtr.next = huffRoot[hIndex];
                huffRoot[hIndex].previous = entryPtr;
                entryPtr.previous = null;
                huffRoot[hIndex] = entryPtr;
                continue;
            }
            HuffEntry searchPtr = huffRoot[hIndex];
            while (searchPtr.next != null && searchPtr.frequency < entryPtr.frequency) {
                searchPtr = searchPtr.next;
            }
            if (searchPtr.frequency < entryPtr.frequency) {
                entryPtr.next = null;
                entryPtr.previous = searchPtr;
                searchPtr.next = entryPtr;
                continue;
            }
            entryPtr.next = searchPtr;
            entryPtr.previous = searchPtr.previous;
            searchPtr.previous.next = entryPtr;
            searchPtr.previous = entryPtr;
        }
    }

    void createCodeArray(HuffEntry huffRoot, int[] huffCodeArray, byte[] huffCodeLengthArray, int codeValue, byte codeLength) {
        if (huffRoot.zeroChild == null && huffRoot.oneChild == null) {
            huffCodeArray[huffRoot.value] = codeValue;
            huffCodeLengthArray[huffRoot.value] = codeLength;
        } else {
            this.createCodeArray(huffRoot.zeroChild, huffCodeArray, huffCodeLengthArray, (codeValue << 1) + 0, (byte)(codeLength + 1));
            this.createCodeArray(huffRoot.oneChild, huffCodeArray, huffCodeLengthArray, (codeValue << 1) + 1, (byte)(codeLength + 1));
        }
    }

    void getNextSbInit(BitInputStream source) throws IOException {
        this.nextBit = (byte)source.getInt(1);
        this.frArrayDeCodeInit();
        while (this.frArrayDeCodeSBRun(source.getBit()) == 0) {
        }
    }

    byte getNextSbBit(BitInputStream source) throws IOException {
        if (this.bitsLeft == 0) {
            this.nextBit = this.nextBit == 1 ? (byte)0 : 1;
            this.frArrayDeCodeInit();
            while (this.frArrayDeCodeSBRun(source.getBit()) == 0) {
            }
        }
        --this.bitsLeft;
        return this.nextBit;
    }

    void getNextBInit(BitInputStream source) throws IOException {
        this.nextBit = (byte)source.getInt(1);
        this.frArrayDeCodeInit();
        while (this.frArrayDeCodeBlockRun(source.getBit()) == 0) {
        }
    }

    byte getNextBBit(BitInputStream source) throws IOException {
        if (this.bitsLeft == 0) {
            this.nextBit = this.nextBit == 1 ? (byte)0 : 1;
            this.frArrayDeCodeInit();
            while (this.frArrayDeCodeBlockRun(source.getBit()) == 0) {
            }
        }
        --this.bitsLeft;
        return this.nextBit;
    }

    void frArrayDeCodeInit() {
        this.bitPattern = 0;
        this.bitsSoFar = 0;
    }

    int frArrayDeCodeSBRun(boolean bitValue) {
        int retVal = 0;
        this.bitsSoFar = (byte)(this.bitsSoFar + 1);
        this.bitPattern = (this.bitPattern << 1) + (bitValue ? 1 : 0);
        switch (this.bitsSoFar) {
            case 1: {
                if (this.bitPattern != 0) break;
                retVal = 1;
                this.bitsLeft = 1;
                break;
            }
            case 3: {
                if ((this.bitPattern & 2) != 0) break;
                retVal = 1;
                this.bitsLeft = (this.bitPattern & 1) + 2;
                break;
            }
            case 4: {
                if ((this.bitPattern & 2) != 0) break;
                retVal = 1;
                this.bitsLeft = (this.bitPattern & 1) + 4;
                break;
            }
            case 6: {
                if ((this.bitPattern & 4) != 0) break;
                retVal = 1;
                this.bitsLeft = (this.bitPattern & 3) + 6;
                break;
            }
            case 8: {
                if ((this.bitPattern & 8) != 0) break;
                retVal = 1;
                this.bitsLeft = (this.bitPattern & 7) + 10;
                break;
            }
            case 10: {
                if ((this.bitPattern & 0x10) != 0) break;
                retVal = 1;
                this.bitsLeft = (this.bitPattern & 0xF) + 18;
                break;
            }
            case 18: {
                retVal = 1;
                this.bitsLeft = (this.bitPattern & 0xFFF) + 34;
                break;
            }
            default: {
                retVal = 0;
            }
        }
        return retVal;
    }

    int frArrayDeCodeBlockRun(boolean bitValue) {
        int retVal = 0;
        this.bitsSoFar = (byte)(this.bitsSoFar + 1);
        this.bitPattern = (this.bitPattern << 1) + (bitValue ? 0 : 1);
        switch (this.bitsSoFar) {
            case 2: {
                if ((this.bitPattern & 2) != 0) break;
                retVal = 1;
                this.bitsLeft = (this.bitPattern & 1) + 1;
                break;
            }
            case 3: {
                if ((this.bitPattern & 2) != 0) break;
                retVal = 1;
                this.bitsLeft = (this.bitPattern & 1) + 3;
                break;
            }
            case 4: {
                if ((this.bitPattern & 2) != 0) break;
                retVal = 1;
                this.bitsLeft = (this.bitPattern & 1) + 5;
                break;
            }
            case 6: {
                if ((this.bitPattern & 4) != 0) break;
                retVal = 1;
                this.bitsLeft = (this.bitPattern & 3) + 7;
                break;
            }
            case 7: {
                if ((this.bitPattern & 4) != 0) break;
                retVal = 1;
                this.bitsLeft = (this.bitPattern & 3) + 11;
                break;
            }
            case 9: {
                retVal = 1;
                this.bitsLeft = (this.bitPattern & 0xF) + 15;
            }
        }
        return retVal;
    }

    void updateQ(int newQ) {
        int qscale = newQ;
        if (qscale < this.qThreshTable[63]) {
            qscale = this.qThreshTable[63];
        } else if (qscale > this.qThreshTable[0]) {
            qscale = this.qThreshTable[0];
        }
        this.frameQIndex = 63;
        while (this.frameQIndex >= 0 && this.frameQIndex != 0 && this.qThreshTable[this.frameQIndex] < newQ) {
            --this.frameQIndex;
        }
        this.initDequantizer(qscale, (byte)this.frameQIndex);
    }

    void initDequantizer(int scaleFactor, byte qIndex) {
        int j;
        int i;
        short[] interCoeffs = Constants.interCoeffsV1;
        short[] yCoeffs = Constants.yCoeffsV1;
        short[] uvCoeffs = Constants.uvCoeffsV1;
        short[] dcScaleFactorTable = Constants.dcScaleFactorTableV1;
        short[] uvDcScaleFactorTable = Constants.dcScaleFactorTableV1;
        this.buildQuantIndexGeneric();
        for (i = 0; i < 64; ++i) {
            j = this.quantIndex[i];
            this.dequantYCoeffs[j] = yCoeffs[i];
        }
        for (i = 0; i < 64; ++i) {
            j = this.quantIndex[i];
            this.dequantInterCoeffs[j] = interCoeffs[i];
        }
        for (i = 0; i < 64; ++i) {
            j = this.quantIndex[i];
            this.dequantYCoeffs[j] = uvCoeffs[i];
        }
        for (i = 0; i < 64; ++i) {
            j = this.quantIndex[i];
            this.dequantInterUvCoeffs[j] = interCoeffs[i];
        }
        this.dequantYCoeffs[0] = (short)(dcScaleFactorTable[qIndex] * this.dequantYCoeffs[0] / 100);
        if (this.dequantYCoeffs[0] < 4) {
            this.dequantYCoeffs[0] = 4;
        }
        this.dequantYCoeffs[0] = (short)(this.dequantYCoeffs[0] << 2);
        this.dequantUvCoeffs[0] = (short)(uvDcScaleFactorTable[qIndex] * this.dequantUvCoeffs[0] / 100);
        if (this.dequantUvCoeffs[0] < 4) {
            this.dequantUvCoeffs[0] = 4;
        }
        this.dequantUvCoeffs[0] = (short)(this.dequantUvCoeffs[0] << 2);
        this.dequantInterCoeffs[0] = (short)(dcScaleFactorTable[qIndex] * this.dequantInterCoeffs[0] / 100);
        if (this.dequantInterCoeffs[0] < 8) {
            this.dequantInterCoeffs[0] = 8;
        }
        this.dequantInterCoeffs[0] = (short)(this.dequantInterCoeffs[0] << 2);
        this.dequantInterUvCoeffs[0] = (short)(uvDcScaleFactorTable[qIndex] * this.dequantInterUvCoeffs[0] / 100);
        if (this.dequantInterUvCoeffs[0] < 8) {
            this.dequantInterUvCoeffs[0] = 8;
        }
        this.dequantInterUvCoeffs[0] = (short)(this.dequantInterUvCoeffs[0] << 2);
        for (i = 1; i < 64; ++i) {
            this.dequantYCoeffs[i] = (short)(scaleFactor * this.dequantYCoeffs[i] / 100);
            if (this.dequantYCoeffs[i] < 2) {
                this.dequantYCoeffs[i] = 2;
            }
            this.dequantYCoeffs[i] = (short)(this.dequantYCoeffs[i] << 2);
            this.dequantUvCoeffs[i] = (short)(scaleFactor * this.dequantUvCoeffs[i] / 100);
            if (this.dequantUvCoeffs[i] < 2) {
                this.dequantUvCoeffs[i] = 2;
            }
            this.dequantUvCoeffs[i] = (short)(this.dequantUvCoeffs[i] << 2);
            this.dequantInterCoeffs[i] = (short)(scaleFactor * this.dequantInterCoeffs[i] / 100);
            if (this.dequantInterCoeffs[i] < 4) {
                this.dequantInterCoeffs[i] = 4;
            }
            this.dequantInterCoeffs[i] = (short)(this.dequantInterCoeffs[i] << 2);
            this.dequantInterUvCoeffs[i] = (short)(scaleFactor * this.dequantInterUvCoeffs[i] / 100);
            if (this.dequantInterUvCoeffs[i] < 4) {
                this.dequantInterUvCoeffs[i] = 4;
            }
            this.dequantInterUvCoeffs[i] = (short)(this.dequantInterUvCoeffs[i] << 2);
        }
        this.dequantCoeffs = this.dequantYCoeffs;
    }

    void buildQuantIndexGeneric() {
        int i = 0;
        while (i < 64) {
            int j = Constants.dequantIndex[i];
            this.quantIndex[j] = i++;
        }
    }

    CodingMode frArrayUnpackMode(BitInputStream source) throws IOException {
        this.bitPattern = 0;
        this.bitsSoFar = 0;
        this.bitPattern = source.getInt(1);
        if (this.bitPattern == 0) {
            return CodingMode.MODES[0];
        }
        this.bitPattern <<= 1;
        if (source.getBit()) {
            ++this.bitPattern;
        }
        if (this.bitPattern == 2) {
            return CodingMode.MODES[1];
        }
        this.bitPattern <<= 1;
        if (source.getBit()) {
            ++this.bitPattern;
        }
        if (this.bitPattern == 6) {
            return CodingMode.MODES[2];
        }
        this.bitPattern <<= 1;
        if (source.getBit()) {
            ++this.bitPattern;
        }
        if (this.bitPattern == 14) {
            return CodingMode.MODES[3];
        }
        this.bitPattern <<= 1;
        if (source.getBit()) {
            ++this.bitPattern;
        }
        if (this.bitPattern == 30) {
            return CodingMode.MODES[4];
        }
        this.bitPattern <<= 1;
        if (source.getBit()) {
            ++this.bitPattern;
        }
        if (this.bitPattern == 62) {
            return CodingMode.MODES[5];
        }
        this.bitPattern <<= 1;
        if (source.getBit()) {
            ++this.bitPattern;
        }
        if (this.bitPattern == 126) {
            return CodingMode.MODES[6];
        }
        return CodingMode.MODES[7];
    }

    void setupBoundingValueArrayGeneric(int fLimit) {
        Arrays.fill(this.filtBoundingValue, 0);
        for (int i = 0; i < fLimit; ++i) {
            this.filtBoundingValue[256 - i - fLimit] = -fLimit + i;
            this.filtBoundingValue[256 - i] = -i;
            this.filtBoundingValue[256 + i] = i;
            this.filtBoundingValue[256 + i + fLimit] = fLimit - i;
        }
    }

    public int getYStride() {
        return this.yStride;
    }

    public int getUvStride() {
        return this.uvStride;
    }

    public int getYOffset() {
        return this.yDataOffset;
    }

    public int getUOffset() {
        return this.uDataOffset;
    }

    public int getVOffset() {
        return this.vDataOffset;
    }
}

