/*
 * Decompiled with CFR 0.152.
 */
package mythruna.mblock;

import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.Direction;
import com.simsilica.mblock.geom.BlockFactory;
import com.simsilica.mblock.geom.BoundaryShape;
import com.simsilica.mblock.geom.BoundaryShapes;
import com.simsilica.mblock.geom.GeomPart;
import com.simsilica.mblock.geom.GeomPartBuffer;
import com.simsilica.mblock.geom.MaterialType;
import com.simsilica.mblock.geom.PrimitiveType;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticParticleBlockFactory
implements BlockFactory {
    static final long serialVersionUID = 42L;
    static Logger log = LoggerFactory.getLogger(StaticParticleBlockFactory.class);
    private BlockFactory delegate;
    private MaterialType mt1;
    private Vec3d min;
    private Vec3d max;
    private int[] counts;
    private double[] heights;
    private int count;
    private double scale;

    public StaticParticleBlockFactory(BlockFactory delegate, MaterialType mt1, double scale, Vec3d min, Vec3d max, int ... counts) {
        this.delegate = delegate;
        this.mt1 = mt1;
        this.scale = scale;
        this.min = min;
        this.max = max;
        this.counts = counts;
        this.heights = new double[counts.length];
        for (int i : counts) {
            this.count += i;
        }
        for (int i = 0; i < this.heights.length; ++i) {
            this.heights[i] = 1.0;
        }
    }

    public void resetCount() {
        this.count = 0;
        for (int i : this.counts) {
            this.count += i;
        }
    }

    public void resetHeights() {
        this.heights = new double[this.counts.length];
        for (int i = 0; i < this.heights.length; ++i) {
            this.heights[i] = 1.0;
        }
    }

    private float range(double s, double min, double max) {
        return (float)(min + s * (max - min));
    }

    private float range(double s, double min, double max, double scale) {
        return (float)(min + s * (max - min) * scale);
    }

    public int addGeometryToBuffer(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, int sideMask, CellData cells, BlockType blockType) {
        if (this.heights == null) {
            this.resetHeights();
        }
        int total = 0;
        if (this.delegate != null) {
            total += this.delegate.addGeometryToBuffer(buffer, x, y, z, xWorld, yWorld, zWorld, sideMask, cells, blockType);
        }
        float[] pos = new float[this.count * 3];
        float[] sizes = new float[this.count];
        float[] texes = new float[this.count * 4];
        int base3 = 0;
        int base4 = 0;
        int index = 0;
        float size = (float)this.scale;
        int types = this.counts.length;
        for (int type = 0; type < types; ++type) {
            int localCount = this.counts[type];
            double localHeight = this.heights[type];
            for (int i = 0; i < localCount; ++i) {
                float xOffset = this.range(buffer.nextRandom(), this.min.x, this.max.x);
                float yOffset = this.range(buffer.nextRandom(), this.min.y, this.max.y, localHeight);
                float zOffset = this.range(buffer.nextRandom(), this.min.z, this.max.z);
                pos[base3] = xOffset;
                pos[base3 + 1] = yOffset;
                pos[base3 + 2] = zOffset;
                sizes[index] = size;
                int s = (int)(buffer.nextRandom() * 4.0);
                int t = type;
                texes[base4] = (float)s * 0.25f;
                texes[base4 + 1] = (float)t * 0.25f + 0.24f;
                texes[base4 + 2] = (float)s * 0.25f + 0.24f;
                texes[base4 + 3] = (float)t * 0.25f;
                ++index;
                base3 += 3;
                base4 += 4;
            }
        }
        GeomPart part = new GeomPart(this.mt1, PrimitiveType.Points, -1, true);
        part.setCoords(pos);
        part.setSizes(sizes);
        part.setTexCoords(texes);
        buffer.addPart(x, y, z, part);
        return ++total;
    }

    public BoundaryShape getShape(Direction dir) {
        return BoundaryShapes.NULL_SHAPE;
    }

    public boolean isSolid(Direction dir) {
        return false;
    }

    public boolean isSolid() {
        return false;
    }

    public double getTransparency(Direction dir) {
        return 1.0;
    }

    public boolean isTransparent() {
        return true;
    }

    public double getVolume() {
        double x = this.getMax().x - this.getMin().x;
        double y = this.getMax().y - this.getMin().y;
        double z = this.getMax().z - this.getMin().z;
        return x * y * z;
    }

    public Vec3d getMin() {
        return this.min;
    }

    public Vec3d getMax() {
        return this.max;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        StaticParticleBlockFactory other = (StaticParticleBlockFactory)o;
        if (other.count != other.count) {
            return false;
        }
        if (!Objects.equals(other.mt1, this.mt1)) {
            return false;
        }
        if (!Objects.equals(other.min, this.min)) {
            return false;
        }
        if (!Objects.equals(other.max, this.max)) {
            return false;
        }
        return Arrays.equals(other.counts, this.counts);
    }

    public int hashCode() {
        return Objects.hash(this.mt1, this.min, this.max, this.count, this.counts);
    }

    public BlockFactory rotate(int dirDelta) {
        return this;
    }
}

