/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.assembly;

import com.jme3.scene.Node;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Selector;
import com.simsilica.lemur.component.TbtQuadBackgroundComponent;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import java.util.Arrays;
import mythruna.assembly.Subassembly;
import mythruna.client.ui.assembly.QuatdEditor;
import mythruna.client.ui.assembly.Vec3dEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubassemblyEditor
extends Container {
    static Logger log = LoggerFactory.getLogger(SubassemblyEditor.class);
    private VersionedHolder<Subassembly> subassembly = new VersionedHolder();
    private static VersionedList<Scale> availableScales = new VersionedList(Arrays.asList(new Scale("25 cm", 0.25), new Scale("12.5 cm", 0.125), new Scale("6.25 cm", 0.0625), new Scale("3.125 cm", 0.03125)));
    private Selector<Scale> scale;
    private VersionedReference<Scale> scaleRef;
    private Vec3dEditor locEditor;
    private VersionedReference<Vec3d> locRef;
    private QuatdEditor rotEditor;
    private VersionedReference<Quatd> rotRef;

    public SubassemblyEditor() {
        Container properties = (Container)this.addChild((Node)new Container(), new Object[0]);
        properties.addChild((Node)new Label("Scale:"), new Object[0]);
        this.scale = (Selector)properties.addChild((Node)new Selector(availableScales), new Object[]{1});
        this.scaleRef = this.scale.createSelectedItemReference();
        TbtQuadBackgroundComponent bg = TbtQuadBackgroundComponent.create((String)"/Interface/drawn-box-64.png", (float)0.25f, (int)10, (int)10, (int)53, (int)53, (float)1.0f, (boolean)false);
        bg.setMargin(0.0f, 3.0f);
        Label label = (Label)this.addChild((Node)new Label("Location:"), new Object[0]);
        label.setFontSize(18.0f);
        this.locEditor = (Vec3dEditor)this.addChild((Node)new Vec3dEditor(Vec3dEditor.createModel(-5.5, 5.5, 0.005, 0.001, 0.0), Vec3dEditor.createModel(-5.5, 5.5, 0.005, 0.001, 0.0), Vec3dEditor.createModel(-5.5, 5.5, 0.005, 0.001, 0.0), "%.3f", 80.0f, 10.0f), new Object[0]);
        this.locRef = this.locEditor.createReference();
        this.locEditor.setBorder((GuiComponent)bg);
        label = (Label)this.addChild((Node)new Label("Orientation:"), new Object[0]);
        label.setFontSize(18.0f);
        this.rotEditor = (QuatdEditor)this.addChild((Node)new QuatdEditor(Vec3dEditor.createModel(-180.0, 180.0, 0.5, 0.1, 0.0), Vec3dEditor.createModel(-90.0, 90.0, 0.5, 0.1, 0.0), Vec3dEditor.createModel(-90.0, 90.0, 0.5, 0.1, 0.0), "%.1f", 80.0f), new Object[0]);
        this.rotRef = this.rotEditor.createReference();
        this.rotEditor.setBorder((GuiComponent)bg.clone());
    }

    public void setSubassembly(Subassembly sub) {
        if (this.subassembly.getObject() != sub) {
            this.subassembly.setObject((Object)sub);
            this.resetFields(sub);
        }
    }

    public VersionedReference<Subassembly> createReference() {
        return this.subassembly.createReference();
    }

    public void updateLogicalState(float tpf) {
        Scale s;
        super.updateLogicalState(tpf);
        if (this.subassembly.getObject() == null) {
            return;
        }
        Subassembly sub = (Subassembly)this.subassembly.getObject();
        boolean changed = false;
        if (this.scaleRef.update() && (s = (Scale)this.scale.getSelectedItem()) != null) {
            sub.setScale(s.value);
            changed = true;
        }
        if (this.locRef.update()) {
            changed = true;
        }
        if (this.rotRef.update()) {
            changed = true;
        }
        if (changed) {
            this.subassembly.incrementVersion();
        }
    }

    protected Scale findScale(double value) {
        for (Scale s : availableScales) {
            if (!(Math.abs(value - s.value) < 0.001)) continue;
            return s;
        }
        return null;
    }

    protected void resetFields(Subassembly sub) {
        this.scale.setSelectedItem((Object)this.findScale(sub.getScale()));
        Vec3d loc = sub.getLocation();
        this.locEditor.setObject(loc);
        Quatd rot = sub.getOrientation();
        this.rotEditor.setObject(rot);
    }

    private static class Scale {
        String name;
        double value;

        public Scale(String name, double value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return this.name;
        }
    }
}

