/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.clothing;

import com.simsilica.mathd.Vec3i;
import mythruna.client.ui.edit.Edit;
import mythruna.fabric.ClothingAccumulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwatchEdit
implements Edit {
    static Logger log = LoggerFactory.getLogger(SwatchEdit.class);
    private ClothingAccumulator builder;
    private Vec3i loc;
    private int value;
    private int undo;

    public SwatchEdit(ClothingAccumulator builder, Vec3i loc) {
        this(builder, loc, -1);
    }

    public SwatchEdit(ClothingAccumulator builder, Vec3i loc, int value) {
        this.builder = builder;
        this.loc = loc;
        this.value = value;
    }

    @Override
    public String toDisplay() {
        return this.loc + "=" + this.value;
    }

    @Override
    public void doEdit() {
        if (this.value == -1) {
            log.info("remove:" + this.loc);
            this.undo = this.builder.removeSwatch(this.loc.x, this.loc.y);
        } else {
            log.info("addValue:" + this.loc + ", " + this.value);
            this.undo = this.builder.addValue(this.loc.x, this.loc.y, this.value);
        }
    }

    @Override
    public void undoEdit() {
        if (this.value == -1) {
            if (this.undo > 0) {
                log.info("undo: addValue:" + this.loc + ", " + this.undo);
                this.builder.addValue(this.loc.x, this.loc.y, this.undo);
            } else {
                log.info("undo: skippig add no-op:" + this.loc + ", " + this.undo);
            }
        } else if (this.undo > 0) {
            log.info("undo: remove::" + this.loc);
            this.builder.removeSwatch(this.loc.x, this.loc.y);
        } else {
            log.info("undo: skippig remove no-op:" + this.loc + ", " + this.undo);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.toDisplay() + "]";
    }
}

