/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.map;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Texture;
import com.jme3.util.BufferUtils;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.es.Name;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Checkbox;
import com.simsilica.lemur.CheckboxModel;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.DefaultCheckboxModel;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.GuiMaterial;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.TileId;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import mythruna.client.GameSessionState;
import mythruna.client.ui.map.MapRootComponent;
import mythruna.client.ui.map.MapViewState;
import mythruna.client.view.AvatarState;
import mythruna.es.ChildOf;
import mythruna.es.MapMarker;
import mythruna.es.ObjectTypeInfo;
import mythruna.es.PortalLink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalNetworkState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(PortalNetworkState.class);
    private EntityData ed;
    private EntityId avatarId;
    private MapViewState map;
    private VersionedReference<Vec3d> posRef;
    private VersionedReference<Double> mapRadiusRef;
    private TileId centerId;
    private Label layersLabel;
    private Container layerToggles;
    private boolean layersInvalid;
    private MapRootComponent mapLayer;
    private Map<String, MarkerLayer> markerLayers = new TreeMap<String, MarkerLayer>();
    private HengeContainer henges;
    private PortalLinkContainer portalLinks;
    private MarkerLayer speculativeNetwork;
    private MarkerLayer miniSpecNetwork;
    private MarkerLayer actualNetwork;
    private ConcurrentLinkedQueue<Marker> dirty = new ConcurrentLinkedQueue();
    private Quad iconTemplate;
    private ListMultimap<Vec3d, Edge> graph = MultimapBuilder.hashKeys().arrayListValues().build();
    private Geometry hengeLines;
    private Geometry hengeLinesOverview;
    private Geometry linkLines;

    protected void initialize(Application app) {
        log.info("initialize()");
        this.ed = ((GameSessionState)this.getState(GameSessionState.class)).getEntityData();
        this.map = (MapViewState)this.getState(MapViewState.class);
        log.info("map:" + this.map);
        GameSessionState sessionState = (GameSessionState)this.getState(GameSessionState.class, true);
        this.avatarId = sessionState.getGameSession().getAvatar();
        this.henges = new HengeContainer(this.ed);
        this.portalLinks = new PortalLinkContainer(this.ed);
        this.mapLayer = new MapRootComponent("markers");
        this.map.addLayer(this.mapLayer);
        this.posRef = ((AvatarState)this.getState(AvatarState.class)).createPositionReference();
        this.mapRadiusRef = this.map.getWorldRadiusRef();
        this.centerId = TileId.fromWorld((Vec3d)((Vec3d)this.posRef.get()));
        float iconSize = 2.0f;
        float halfSize = iconSize * 0.5f;
        this.iconTemplate = new Quad(iconSize, iconSize);
        this.iconTemplate.setBuffer(VertexBuffer.Type.Position, 3, new float[]{-halfSize, -halfSize, 0.0f, halfSize, -halfSize, 0.0f, halfSize, halfSize, 0.0f, -halfSize, halfSize, 0.0f});
        this.layersLabel = new Label("Portal Debug:");
        this.layerToggles = new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.None, FillMode.First));
        this.map.addRightPanel((Panel)this.layerToggles);
        this.actualNetwork = this.getMarkerLayer("Actual Network", true);
        this.actualNetwork.setChecked(false);
        this.speculativeNetwork = this.getMarkerLayer("Speculative Network", true);
        this.speculativeNetwork.setChecked(false);
        this.miniSpecNetwork = this.getMarkerLayer("Mini Spec. Network", true);
        this.miniSpecNetwork.setChecked(false);
        this.updateFilters();
    }

    protected void cleanup(Application app) {
        log.info("cleanup()");
        this.map.removeRightPanel((Panel)this.layerToggles);
    }

    protected void onEnable() {
        log.info("onEnable()");
        this.henges.start();
        this.portalLinks.start();
    }

    protected void onDisable() {
        log.info("onDisable()");
        this.henges.stop();
        this.portalLinks.stop();
    }

    public void update(float tpf) {
        boolean viewChanged = false;
        boolean posChanged = false;
        if (this.posRef.update()) {
            posChanged = true;
            TileId tileId = TileId.fromWorld((Vec3d)((Vec3d)this.posRef.get()));
            if (tileId.getId() != this.centerId.getId()) {
                this.centerId = tileId;
                viewChanged = true;
            }
        }
        if (this.mapRadiusRef.update()) {
            viewChanged = true;
            posChanged = true;
        }
        if (viewChanged) {
            this.updateFilters();
        }
        if (this.henges.update()) {
            this.updateHengeLinks();
        }
        if (this.portalLinks.update()) {
            this.updatePortalLinks();
        }
        if (this.map.isEnabled()) {
            this.updatePositions(posChanged);
        }
        if (this.layersInvalid) {
            this.updateLayers();
        }
    }

    protected void updateLayers() {
        this.layerToggles.clearChildren();
        this.layerToggles.addChild((Node)this.layersLabel, new Object[0]);
        for (MarkerLayer layer : this.markerLayers.values()) {
            this.layerToggles.addChild((Node)layer.checkbox, new Object[0]);
        }
    }

    protected void updateFilters() {
        ComponentFilter tileFilter;
        log.info("updateFilters() tile:" + this.centerId + "  radius:" + this.mapRadiusRef.get());
        Vec3i center = this.centerId.getWorld(null);
        int radius = (int)Math.round((Double)this.mapRadiusRef.get() / 1024.0);
        int size = radius * 2 + 1;
        log.info(" filter array size:" + size * size);
        ComponentFilter[] filters = new ComponentFilter[size * size];
        int index = 0;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                Vec3i loc = center.add(x * 1024, 0, z * 1024);
                TileId neighbor = TileId.fromWorld((Vec3i)loc);
                ComponentFilter filter = Filters.fieldEquals(MapMarker.class, (String)"tileId", (Object)neighbor.getId());
                filters[index++] = filter;
            }
        }
        ComponentFilter finalFilter = tileFilter = Filters.or(MapMarker.class, (ComponentFilter[])filters);
    }

    protected void updatePositions(boolean posChanged) {
        Vec3d worldCenter = (Vec3d)this.posRef.get();
        double radius = (Double)this.mapRadiusRef.get();
        double scale = this.mapLayer.getWorldToLocalScale();
        for (Marker m : this.henges.getArray()) {
            m.updatePosition(worldCenter, radius, scale);
        }
        if (posChanged) {
            log.info("updating links...");
            this.updateHengeLinks();
            this.updatePortalLinks();
        }
    }

    protected Edge findLink(Marker start, Marker end) {
        for (Edge e : this.graph.get((Object)start.pos)) {
            if (end != e.end2) continue;
            return e;
        }
        return null;
    }

    protected List<Marker> getNeighbors(Marker hub, double radius) {
        ArrayList<Marker> neighbors = new ArrayList<Marker>();
        for (Marker n : this.henges.getArray()) {
            if (n == hub) continue;
            double d = hub.pos.distance(n.pos);
            if (d == 0.0) {
                log.error("Duplicate markers:" + hub + ", " + n);
            }
            if (!(d <= radius)) continue;
            neighbors.add(n);
        }
        return neighbors;
    }

    protected List<Edge> createLinks(Marker hub, double radius) {
        List<Marker> neighbors = this.getNeighbors(hub, radius);
        int numDirs = 8;
        Edge[] dirs = new Edge[numDirs];
        ArrayList<Edge> links = new ArrayList<Edge>();
        for (Marker n : neighbors) {
            int dir;
            Edge link = new Edge(this, hub, n);
            links.add(link);
            double angle = Math.atan2(n.pos.z - hub.pos.z, n.pos.x - hub.pos.x);
            double angleDelta = Math.PI * 2 / (double)numDirs;
            angle += angleDelta * 0.5;
            if (angle < 0.0) {
                angle += Math.PI * 2;
            }
            if (dirs[dir = (int)(angle / angleDelta)] == null) {
                dirs[dir] = link;
                continue;
            }
            if (dirs[dir].length() > link.length()) {
                dirs[dir].enabled = false;
                dirs[dir] = link;
                continue;
            }
            link.enabled = false;
        }
        for (Edge link : links) {
            Edge back = this.findLink(link.end2, link.end1);
            if (back != null) {
                if (!back.enabled) {
                    link.enabled = false;
                } else if (!link.enabled) {
                    back.enabled = false;
                }
            }
            this.graph.put((Object)link.end1.pos, (Object)link);
        }
        return links;
    }

    protected void updateHengeLinks() {
        int gateRadius = 12;
        int radius = gateRadius * 1024;
        int nearRadius = 8192;
        int midRadius = 10240;
        ArrayList<Vector3f> points = new ArrayList<Vector3f>();
        ArrayList<Vector4f> colors = new ArrayList<Vector4f>();
        this.graph.clear();
        Marker[] array = this.henges.getArray();
        for (int i = 0; i < array.length; ++i) {
            Marker m1 = array[i];
            List<Edge> list = this.createLinks(m1, radius);
        }
        for (Edge edge : this.graph.values()) {
            double d;
            Vector4f color = !edge.enabled ? new Vector4f(0.0f, 0.0f, 0.0f, 0.1f) : ((d = edge.length()) <= (double)nearRadius ? ColorRGBA.Green.toVector4f() : (d <= (double)midRadius ? ColorRGBA.Blue.toVector4f() : ColorRGBA.Red.toVector4f()));
            colors.add(color);
            colors.add(color);
            points.add(edge.end1.node.getLocalTranslation());
            points.add(edge.end2.node.getLocalTranslation());
        }
        double guiScale = this.mapLayer.getWorldToLocalScale();
        Vec3d worldCenter = (Vec3d)this.posRef.get();
        Vec3d local = ((Vec3d)this.posRef.get()).subtract(worldCenter);
        local.multLocal(guiScale);
        Vector3f center = new Vector3f((float)local.x, (float)(-local.z), 10.0f);
        float size = 10.0f;
        points.add(center.subtract(size, 0.0f, 0.0f));
        points.add(center.add(size, 0.0f, 0.0f));
        points.add(center.subtract(0.0f, size, 0.0f));
        points.add(center.add(0.0f, size, 0.0f));
        points.add(center.subtract(size, size, 0.0f));
        points.add(center.add(size, size, 0.0f));
        points.add(center.subtract(size, -size, 0.0f));
        points.add(center.add(size, -size, 0.0f));
        colors.add(ColorRGBA.Cyan.toVector4f());
        colors.add(ColorRGBA.Cyan.toVector4f());
        colors.add(ColorRGBA.Cyan.toVector4f());
        colors.add(ColorRGBA.Cyan.toVector4f());
        colors.add(ColorRGBA.Cyan.toVector4f());
        colors.add(ColorRGBA.Cyan.toVector4f());
        colors.add(ColorRGBA.Cyan.toVector4f());
        colors.add(ColorRGBA.Cyan.toVector4f());
        Vector3f[] posData = points.toArray(new Vector3f[0]);
        FloatBuffer posBuff = BufferUtils.createFloatBuffer((Vector3f[])posData);
        Vector4f[] colorData = colors.toArray(new Vector4f[0]);
        FloatBuffer colorBuff = BufferUtils.createFloatBuffer((Vector4f[])colorData);
        Mesh mesh = new Mesh();
        mesh.setMode(Mesh.Mode.Lines);
        mesh.setBuffer(VertexBuffer.Type.Position, 3, posBuff);
        mesh.setBuffer(VertexBuffer.Type.Color, 4, colorBuff);
        if (this.hengeLines == null) {
            this.hengeLines = new Geometry("hengeLines", mesh);
            this.hengeLines.setMaterial(GuiGlobals.getInstance().createMaterial(new ColorRGBA(1.0f, 1.0f, 1.0f, 0.25f), false).getMaterial());
            this.hengeLines.getMaterial().setBoolean("VertexColor", true);
            this.hengeLines.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
            this.hengeLinesOverview = this.hengeLines.clone(true);
            this.hengeLinesOverview.getMaterial().setColor("Color", ColorRGBA.White);
            this.hengeLinesOverview.setLocalScale(0.1f);
            this.speculativeNetwork.root.attachChild((Spatial)this.hengeLines);
            this.miniSpecNetwork.root.attachChild((Spatial)this.hengeLinesOverview);
        } else {
            this.hengeLines.setMesh(mesh);
            this.hengeLinesOverview.setMesh(mesh);
        }
        this.hengeLines.updateModelBound();
    }

    protected void updatePortalLinks() {
        ArrayList<Vector3f> points = new ArrayList<Vector3f>();
        ArrayList<Vector4f> colors = new ArrayList<Vector4f>();
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (LinkView view : this.portalLinks.getArray()) {
            PortalLink link = view.link;
            ChildOf p1 = (ChildOf)this.ed.getComponent(link.getSource(), ChildOf.class);
            if (p1 == null) {
                log.info("Source:" + link.getSource() + " has no ChildOf component");
                continue;
            }
            ChildOf p2 = (ChildOf)this.ed.getComponent(link.getTarget(), ChildOf.class);
            if (p2 == null) continue;
            Marker m1 = (Marker)this.henges.getObject(p1.getParent());
            Marker m2 = (Marker)this.henges.getObject(p2.getParent());
            if (m1 == null || m2 == null) continue;
            edges.add(new Edge(this, m1, m2, link.isEnabled()));
        }
        for (Edge edge : edges) {
            Vector4f color = !edge.enabled ? new Vector4f(1.0f, 0.0f, 1.0f, 0.15f) : new Vector4f(1.0f, 1.0f, 0.0f, 1.0f);
            Vector4f shadow = new Vector4f(0.0f, 0.0f, 0.0f, color.w);
            colors.add(shadow);
            colors.add(shadow);
            points.add(edge.end1.node.getLocalTranslation().add(1.0f, -1.0f, 0.0f));
            points.add(edge.end2.node.getLocalTranslation().add(1.0f, -1.0f, 0.0f));
            colors.add(color);
            colors.add(color);
            points.add(edge.end1.node.getLocalTranslation());
            points.add(edge.end2.node.getLocalTranslation());
        }
        Vector3f[] posData = points.toArray(new Vector3f[0]);
        FloatBuffer posBuff = BufferUtils.createFloatBuffer((Vector3f[])posData);
        Vector4f[] colorData = colors.toArray(new Vector4f[0]);
        FloatBuffer colorBuff = BufferUtils.createFloatBuffer((Vector4f[])colorData);
        Mesh mesh = new Mesh();
        mesh.setMode(Mesh.Mode.Lines);
        mesh.setBuffer(VertexBuffer.Type.Position, 3, posBuff);
        mesh.setBuffer(VertexBuffer.Type.Color, 4, colorBuff);
        if (this.linkLines == null) {
            this.linkLines = new Geometry("linkLines", mesh);
            this.linkLines.setMaterial(GuiGlobals.getInstance().createMaterial(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f), false).getMaterial());
            this.linkLines.getMaterial().setBoolean("VertexColor", true);
            this.linkLines.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
            this.linkLines.move(5.0f, 5.0f, 0.0f);
            this.actualNetwork.root.attachChild((Spatial)this.linkLines);
        } else {
            this.linkLines.setMesh(mesh);
        }
        this.linkLines.updateModelBound();
    }

    protected Icon getIcon(String type) {
        String resource = "Interface/markers/marker-round.png";
        ColorRGBA color = ColorRGBA.Blue;
        float labelScale = 0.075f;
        float iconScale = 1.0f;
        Texture texture = this.getApplication().getAssetManager().loadTexture(resource);
        GuiMaterial material = GuiGlobals.getInstance().createMaterial(color, false);
        material.setTexture(texture);
        Mesh quad = this.iconTemplate.clone();
        Geometry geom = new Geometry(type, quad);
        Material mat = material.getMaterial();
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        geom.setMaterial(mat);
        geom.setLocalScale(iconScale);
        Node node = new Node(type + ":holder");
        node.attachChild((Spatial)geom);
        return new Icon(this, (Spatial)node, labelScale);
    }

    protected MarkerLayer getMarkerLayer(String type, boolean create) {
        MarkerLayer result = this.markerLayers.get(type);
        if (result == null && create) {
            result = new MarkerLayer(type, true);
            this.markerLayers.put(type, result);
            this.layersInvalid = true;
        }
        return result;
    }

    private class HengeContainer
    extends EntityContainer<Marker> {
        public HengeContainer(EntityData ed) {
            super(ed, new Class[]{MapMarker.class, Name.class, SpawnPosition.class});
            int hengeId = ed.getStrings().getStringId("Spirit Henge", false);
            ComponentFilter filter = Filters.fieldEquals(MapMarker.class, (String)"typeId", (Object)hengeId);
            this.setFilter(filter);
        }

        public void setFilter(ComponentFilter filter) {
            super.setFilter(filter);
        }

        public Marker[] getArray() {
            return (Marker[])super.getArray();
        }

        protected Marker addObject(Entity entity) {
            log.info("Henge.addObject(" + entity + ")");
            Marker result = new Marker(entity);
            this.updateObject(result, entity);
            return result;
        }

        protected void updateObject(Marker marker, Entity entity) {
            log.info("Henge.updateObject(" + entity + ")");
            log.info("Henge.entity type:" + PortalNetworkState.this.ed.getComponent(entity.getId(), ObjectTypeInfo.class));
            marker.update(entity);
        }

        protected void removeObject(Marker marker, Entity entity) {
            log.info("Henge.removeObject(" + entity + ")");
            marker.release();
        }
    }

    private class PortalLinkContainer
    extends EntityContainer<LinkView> {
        public PortalLinkContainer(EntityData ed) {
            super(ed, new Class[]{PortalLink.class});
        }

        public LinkView[] getArray() {
            return (LinkView[])super.getArray();
        }

        protected LinkView addObject(Entity entity) {
            log.info("PortalLink.addObject(" + entity + ")");
            LinkView result = new LinkView(PortalNetworkState.this, entity);
            this.updateObject(result, entity);
            return result;
        }

        protected void updateObject(LinkView linkView, Entity entity) {
            log.info("PortalLink.updateObject(" + entity + ")");
            linkView.update(entity);
        }

        protected void removeObject(LinkView linkView, Entity entity) {
            log.info("PortalLink.removeObject(" + entity + ")");
            linkView.release();
        }
    }

    private class MarkerLayer
    extends DefaultCheckboxModel {
        private String type;
        private boolean visible;
        private Node root;
        private List<Marker> list = new ArrayList<Marker>();
        private Checkbox checkbox;

        public MarkerLayer(String type, boolean visible) {
            this.type = type;
            this.visible = visible;
            this.root = new Node("layer:" + type);
            this.resetVisible();
            this.checkbox = new Checkbox(type + " (0)", (CheckboxModel)this);
            super.setChecked(visible);
        }

        protected void resetLabel() {
            this.checkbox.setText(this.type + " (" + this.list.size() + ")");
        }

        public void setChecked(boolean checked) {
            super.setChecked(checked);
            this.setVisible(checked);
        }

        public void setVisible(boolean visible) {
            if (this.visible == visible) {
                return;
            }
            this.visible = visible;
            this.resetVisible();
        }

        protected void resetVisible() {
            if (this.visible) {
                PortalNetworkState.this.mapLayer.getLayerRoot().attachChild((Spatial)this.root);
            } else {
                this.root.removeFromParent();
            }
        }

        public void addMarker(Marker marker) {
            this.list.add(marker);
            this.root.attachChild((Spatial)marker.node);
            this.resetLabel();
        }

        public void removeMarker(Marker marker) {
            if (this.list.remove(marker)) {
                this.root.detachChild((Spatial)marker.node);
                this.resetLabel();
            }
        }
    }

    private class Marker {
        private Entity entity;
        private MapMarker info;
        private String type;
        private Node node;
        private Label label;
        private Icon icon;
        private Vec3d pos;
        private Quatd orientation;

        public Marker(Entity entity) {
            this.entity = entity;
            this.node = new Node("marker:" + entity.getId());
            this.label = new Label("NA", new ElementId("map.marker.label"));
            this.node.attachChild((Spatial)this.label);
        }

        public void update(Entity entity) {
            this.pos = ((SpawnPosition)entity.get(SpawnPosition.class)).getLocation();
            this.orientation = ((SpawnPosition)entity.get(SpawnPosition.class)).getOrientation();
            String name = ((Name)entity.get(Name.class)).getName();
            if (!Objects.equals(name, this.label.getText())) {
                this.label.setText(name);
                Vector3f size = this.label.getSize();
                this.label.setLocalTranslation(-size.x * 0.5f, 0.0f, 0.0f);
            }
            this.info = (MapMarker)entity.get(MapMarker.class);
            this.updateType(this.info.getTypeName(PortalNetworkState.this.ed));
        }

        protected void updateType(String type) {
            MarkerLayer layer;
            if (Objects.equals(this.type, type)) {
                return;
            }
            if (this.icon != null) {
                this.icon.spatial.removeFromParent();
            }
            if (this.type != null && (layer = PortalNetworkState.this.getMarkerLayer(this.type, false)) != null) {
                layer.removeMarker(this);
            }
            this.type = type;
            this.icon = PortalNetworkState.this.getIcon(type);
            this.node.attachChild(this.icon.spatial);
            PortalNetworkState.this.getMarkerLayer(type, true).addMarker(this);
        }

        public void updatePosition(Vec3d worldCenter, double radius, double worldToLocalScale) {
            if (this.pos == null) {
                return;
            }
            double guiScale = worldToLocalScale;
            Vec3d local = this.pos.subtract(worldCenter);
            local.multLocal(worldToLocalScale);
            this.node.setLocalTranslation((float)local.x, (float)(-local.z), 10.0f);
            double labelScale = (double)this.info.getSize() * guiScale * (double)this.icon.labelScale;
            double iconScale = (double)this.info.getSize() * guiScale;
            if (labelScale > 2.0) {
                labelScale = 2.0;
            }
            Vector3f size = this.label.getSize();
            float labelExtent = this.icon != null ? (float)((double)size.x * labelScale * 0.5) : (float)((double)size.x * guiScale * 0.5);
            this.label.setLocalTranslation(-labelExtent, 0.0f, 0.0f);
            if (this.icon != null) {
                this.label.setLocalScale((float)labelScale);
                this.icon.spatial.setLocalScale((float)iconScale);
            } else {
                this.label.setLocalScale((float)guiScale);
            }
            Vector3f v = this.node.getLocalTranslation();
            boolean labelVisible = true;
            boolean iconVisible = true;
            float viewRadius = PortalNetworkState.this.mapLayer.getLayerSize().x * 0.5f;
            if (v.x - labelExtent < -viewRadius) {
                labelVisible = false;
            }
            if (v.x < -viewRadius) {
                iconVisible = false;
            }
            if (v.x + labelExtent > viewRadius) {
                labelVisible = false;
            }
            if (v.x > viewRadius) {
                iconVisible = false;
            }
            if (v.y < -viewRadius) {
                labelVisible = false;
                iconVisible = false;
            }
            if (v.y > viewRadius) {
                labelVisible = false;
                iconVisible = false;
            }
            if (labelVisible) {
                this.label.setCullHint(Spatial.CullHint.Inherit);
            } else {
                this.label.setCullHint(Spatial.CullHint.Always);
            }
            if (iconVisible) {
                this.icon.spatial.setCullHint(Spatial.CullHint.Inherit);
            } else {
                this.icon.spatial.setCullHint(Spatial.CullHint.Always);
            }
        }

        public void release() {
            MarkerLayer layer;
            this.node.removeFromParent();
            if (this.type != null && (layer = PortalNetworkState.this.getMarkerLayer(this.type, false)) != null) {
                layer.removeMarker(this);
            }
        }
    }

    private class Edge {
        Marker end1;
        Marker end2;
        boolean enabled = true;

        public Edge(PortalNetworkState portalNetworkState, Marker end1, Marker end2) {
            this.end1 = end1;
            this.end2 = end2;
        }

        public Edge(PortalNetworkState portalNetworkState, Marker end1, Marker end2, boolean enabled) {
            this.end1 = end1;
            this.end2 = end2;
            this.enabled = enabled;
        }

        public double length() {
            return this.end1.pos.distance(this.end2.pos);
        }
    }

    private class LinkView {
        private Entity entity;
        private PortalLink link;

        public LinkView(PortalNetworkState portalNetworkState, Entity entity) {
            this.entity = entity;
        }

        public void update(Entity entity) {
            this.link = (PortalLink)entity.get(PortalLink.class);
        }

        public void release() {
        }
    }

    private class Icon {
        Spatial spatial;
        float labelScale;

        public Icon(PortalNetworkState portalNetworkState, Spatial spatial, float labelScale) {
            this.spatial = spatial;
            this.labelScale = labelScale;
        }
    }
}

