#import "Common/ShaderLib/GLSLCompat.glsllib"

#if defined(HAS_GLOWMAP) || defined(HAS_COLORMAP) || (defined(HAS_LIGHTMAP) && !defined(SEPARATE_TEXCOORD))
    #define NEED_TEXCOORD1
#endif

#if defined(DISCARD_ALPHA)
    uniform float m_AlphaDiscardThreshold;
#endif

uniform vec4 m_Color;
uniform sampler2D m_ColorMap;
uniform sampler2D m_LightMap;

#ifdef DESATURATION
    uniform float m_DesaturationValue;
#endif

varying vec2 texCoord1;
varying vec2 texCoord2;

varying vec4 vertColor;

varying float textureOffset;

//#define MORE_SOLID
#define DOUBLE_SAMPLE

void main(){
    vec4 color = vec4(1.0);

    float ramp = texCoord1.y;
    float invRamp = 1.0 - texCoord1.y; 
    ramp = 1.0 - (ramp * ramp);
    invRamp = invRamp * invRamp;

    #ifdef HAS_COLORMAP
        // Smaller texture changes make the texture move faster... so 
        // normal intuition is backwards.s
        vec4 sample = texture2D(m_ColorMap, texCoord1 + vec2(0, -(textureOffset + invRamp * 0.25)));
        color *= sample.x;
        
        #ifdef DOUBLE_SAMPLE
            vec4 sample2 = texture2D(m_ColorMap, texCoord1 * vec2(0.1, 1));
            color += sample2.y * 0.2;
        #endif
    #endif

    #ifdef HAS_VERTEXCOLOR
        color *= vertColor;
    #endif

    #ifdef HAS_COLOR
        #ifdef MORE_SOLID
            color = mix(color * m_Color, m_Color, ramp);
        #else
            color = mix(color * m_Color, m_Color, invRamp);
        #endif
    #endif

    #ifdef HAS_LIGHTMAP
        #ifdef SEPARATE_TEXCOORD
            color.rgb *= texture2D(m_LightMap, texCoord2).rgb;
        #else
            color.rgb *= texture2D(m_LightMap, texCoord1).rgb;
        #endif
    #endif

    #if defined(DISCARD_ALPHA)
        if(color.a < m_AlphaDiscardThreshold){
           discard;
        }
    #endif
    
    #ifdef DESATURATION
        vec3 gray = vec3(dot(vec3(0.2126,0.7152,0.0722), color.rgb));
        color.rgb = vec3(mix(color.rgb, gray, m_DesaturationValue));       
    #endif

    #ifdef MORE_SOLID
        //color.g = ramp; 
        //color.b = invRamp;
        color.a = min(0.7, invRamp);
    #else
        color.a = min(0.8, invRamp);
    #endif 

    gl_FragColor = color;
}
