
chattySpiritTemples = false;
chattyPortals = false;
chattyMoonGates = false;


createType("SpiritTemple").with {

    setTypeVar("defaultName", "Lunar Temple");

    supertypes("BaseObject");

    addAction("initialize") { ->
        log.info("MG:initialize:" + self);
        //self << ShapeInfo.create("/Models/objects/bladder.blocks", 2.0);
        //spirtTempleInit.call(session, self);

        def gate = findTempleGate(self);
        if( gate ==  null ) {
            gate = type("MoonGate").newInstance(new ChildOf(self));
        }

        // Place it at the right location in this temple
        def gateLoc = calculateGateLocation(self);
        gate << new SpawnPosition(gateLoc, new Quatd());
    }

    addAction("onTriggerApproached") { EntityId mob ->
        if( chattySpiritTemples ) {
            echo("SpiritTemple: approaching");
        }
        def gate = findTempleGate(self);
        if( gate ) {
            //templeApproached.call(session, gate);
            onBackground {
                buildPortalLinks.call(gate);
            }
        } else {
            echo("ERROR: no gate found for:" + self);
        }
        return true;
    }

    // Really we'd only want to do that the first time someone
    // approaches... or the first time in a while.  And anyway,
    // a little mystery is ok.
    //addAction("onTriggerEntered") { EntityId mob ->
    //    echo("A strange energy permeates this place.");
    //}

    addAction("Test") { ->
        echo("Testing");
        spirtTempleInit.call(session, self);
    }

    addAction("Init Gate") { ->
        def gate = findTempleGate(self);
        gate.run("initialize");
    }

    addAction("Reset Portals") { ->
        //portalReset.call(session, self);
        log.info("MG:portalReset(" + session + ", " + self + ")");
        if( chattySpiritTemples ) {
            session.echo("Resetting portals for:" + self);
        }
        def gate = findTempleGate(self);
        if( gate ) {
            resetPortalPositions(gate);
        } else {
            log.warn("Temple has no gate.");
            echo("Temple has no gate.");
        }
    }

    addAction("Enable") { ->
        findTempleGate(self)?.run("enable");
    }

    addAction("Disable") { ->
        findTempleGate(self)?.run("disable");
    }

    //addAction("Add Blindness") { ->
    //    activator << new VisionEffect(VisionEffect.FX_PORTAL_BLINDNESS);
    //}.onlyIf {
    //    return activator[VisionEffect] == null;
    //}
    //
    //addAction("Remove Blindness") { ->
    //    activator.remove(VisionEffect);
    //}.onlyIf {
    //    return activator[VisionEffect] != null;
    //}
}

createType("ActivatedObject").with {
    addAction("activate") { ->
        log.info("MG:activate:" + self);
        def count = self[ActivationCount];
        log.info("MG:activate:" + self + " count:" + count);
        if( count == null ) {
            count = new ActivationCount(1);
        } else {
            count = count.increment();
        }
        self << count;
        if( count.count == 1 ) {
            log.info("MG:running onActivate for:" + self);
            runIfExists("onActivate");
        }
    }

    addAction("deactivate") { ->
        def count = self[ActivationCount];
        log.info("MG:deactivate:" + self + " count:" + count);
        if( count == null ) {
            log.error("Deactivate called with no activation count on:" + self);
            return;
        }
        count = count.decrement();
        self << count;
        if( count.count == 0 ) {
            log.info("MG:running onDeactivate for:" + self);
            runIfExists("onDeactivate");
        }
    }

    addAction("clearActivation") { ->
        def count = self[ActivationCount];
        log.info("MG:clearActivation:" + self + " count:" + count);
        if( count == null ) {
            return;
        }
        if( count.count != 0 ) {
            self << new ActivationCount(0);
            log.info("MG:running onDeactivate for:" + self);
            runIfExists("onDeactivate");
        }
    }
}

createType("Portal").with {
    supertypes("BaseObject", "ActivatedObject");

    setTypeVar("defaultName", "Swirling Portal");
    setTypeVar("description",
        "A hole in space and time through which you see an infinitely swirling cloudscape.");
    // Needs to start invisible
    setTypeVar("enabledShape",
               ShapeInfo.create("/objects/portal.j3o", 1.0));
    setTypeVar("brokenShape",
               ShapeInfo.create("/objects/dead-portal.j3o", 1.0));

    addAction("move") { Vec3d loc, Quatd rotation ->
        // Can't move it
    }

    addAction("resetEnabled") { ->
        //portalResetEnabled.call(session, self);
        log.info("MG:Reset enabled state on portal:" + self + " at:" + self.location);

        def count = self[ActivationCount];
        if( count.count <= 0 ) {
            log.info("MG:Portal deactivated");
            clearPortal(self);
            return;
        }
        def link = self[PortalLink];
        if( !link.enabled ) {
            log.info("MG:Portal disabled");
            clearPortal(self);
            return;
        }

        // If the link is too long for the current moon phase then we
        // might also be 'broken'

        def targetGate = findTempleGate(link.target);
        if( targetGate ) {
            def portalLoc = self.location;
            self << ShapeInfo.create("/objects/portal.j3o", 1);
            self << new TriggerInfo(TileId.fromWorld(portalLoc), 1, 2, 1, 0);
            int magic = BlockTypeIndex.findType(new BlockName("aura", "purple"));
            world.setWorldCell(portalLoc, magic);
            world.setWorldCell(portalLoc.add(0, 1, 0), 0);
            return;
        }

        // Else we are a dead portal
        clearPortal(self);
        self << ShapeInfo.create("/objects/dead-portal.j3o", 1);

        def targetLoc = link.target[ChildOf]?.parent?.location;
        if( targetLoc ) {
            onBackground {
                def tileId = TileId.fromWorld(targetLoc);
                log.info("loading tile:" + tileId);
                def tile = tileManager.getTile(tileId, Resolution.High);
                log.info("loaded:" + tile);
                log.info("check:" + findTempleGate(link.target));

                // Give the spooling some time to settle before checking again.
                // When a gate had a lot of 'broken' portals, a straight spool would
                // sometimes miss enabling the portal for being too quick.
                self << ScheduledAction.seconds(1, self, "resetEnabled");
                // Note: if things go really really wrong then the above could end
                // up as an infinite loop.  All of the links would have to be good
                // but the temple gate somehow still not found, though.
            }
        }
    }

    addAction("onActivate") { ->
        //portalActivated.call(session, self);
        log.info("MG:onActivate:" + self);
        run("resetEnabled");
    }

    addAction("onDeactivate") { ->
        //portalDeactivated.call(session, self);
        log.info("MG:onDeactivate:" + self);
        run("resetEnabled");
    }

    addAction("onTriggerEntered") { EntityId mob ->
        if( chattyPortals ) {
            echo("Poof:" + self.name);
        }
        //portalEntered.call(session, self);

        def gate = self[ChildOf]?.parent;
        def player = resolveEntityId(activator);
        def tag = getPortalMobTag(player, gate);
        if( tag == null ) {
            echo("You feel a tingling but nothing happens.");
            return;
        }
        if( chattyPortals ) {
            echo("Teleport... from:" + gate.name + " " + gate + "  tag:" + tag);
        }

        def link = self[PortalLink];
        def targetLoc = getGateLocation(link.source, link.target);

        if( targetLoc == null ) {
            echo("Something is wrong with this portal, target:" + link.target);
            log.warn("Portal:" + self + " is missing a target loc for:" + link.target);
            return;
        }

        def relative = player.location - gate.location;
        log.info("target location:" + targetLoc);

        def warpLoc = targetLoc + relative;
        def newPos = new SpawnPosition(warpLoc, player.orientation);

        echo("An energy vortex pulls you.... somewhere...");
        player.run("warpTo", newPos);
    }
}

createType("MoonGate").with {

    supertypes("BaseObject", "ActivatedObject");

    setTypeVar("defaultName", "Glowing Cloud");
    setTypeVar("description",
        "A mysterious glowing shower of moonlight.");
    setTypeVar("enabledShape",
               ShapeInfo.create("/objects/moon-gate.j3o", 1.0));
    setTypeVar("disabledShape", null);

    addAction("Look") { ->
        superRun();
    }

    //addAction("Reinitialize") { ->
    //    run("initialize");
    //}

    addAction("initialize") { ->
        log.info("MG:initialize:" + self);
        //gateInit.call(session, self);

        //def now = worldTime.clone();
        //int day = now.day;
        //if( now.hour < 6 ) {
        //    // We are already in the next morning after midnight so we really
        //    // want to start the schedule yesterday.
        //    day--;
        //}
        //
        //def moonUp = new WorldTime(now.year, now.month, day, 20, 0);

        // Call us back at moon-up every day at moon rise
        def moonUp = getMoonRise();
        def dayInterval = new WorldTime(0, 0, 1, 0, 0);
        self << new ScheduledTime(moonUp, dayInterval);
    }

    addAction("move") { Vec3d loc, Quatd rotation ->
        // Can't move it
    }

    addAction("onScheduledTime") { ->
        //gateScheduled.call(session, self);

        // See if we should enable the gate
        if( getMoonStrength() < 0.25 ) {
            return;
        }

        // Get the current "moon rise" which will either be in the future
        // or 'last night'.
        def moonUp = getMoonRise();

        // If it's in the future then we are not in 'night time' anymore.
        // This event was run late and missed night time.
        // Without this, advancing from one day to the next might leave
        // a gate open for an entire day.
        if( moonUp > worldTime ) {
            log.info("Moonset has already passed, not enabling gate:" + self);
            return;
        }

        // Otherwise, we are good to enable
        self.run("enable");

        // 6 AM the day after the moon rise... or 10 hours from 8 PM
        def moonDown = new WorldTime();
        moonDown.setHour(10);
        moonDown = moonUp.add(moonDown);

        // Disable ourselves then
        self << ScheduledAction.atWorldTime(moonDown, self, "disable");
    }

    addAction("enable") { ->
        //set trigger, shape, sound, lighting, etc.
        //(everything but the trigger and lighting could be a list configured on the type)
        //gateEnabled.call(session, self);
        log.info("gateEnabled:" + self);

        def gateLoc = self.location;
        self << getTypeVar("enabledShape", null);
        //self << ShapeInfo.create("/objects/moon-gate.j3o", 1);
        self << new TriggerInfo(TileId.fromWorld(gateLoc), 1, 2, 1, 5);

        int magic = BlockTypeIndex.findType(new BlockName("aura", "blue"));

        // Make sure that section of the world is also clear and lit
        world.setWorldCell(gateLoc, magic);
        world.setWorldCell(gateLoc.add(0, 1, 0), magic);

        self << SoundInfo.create("/Sounds/Effects/MoonGateSounds.ogg", now(), 0.25, true, entityData);
    }

    addAction("disable") { ->
        log.info("gateDisabled:" + self);
        //remove trigger, shape, sound, lighting, etc.
        //gateDisabled.call(session, self);
        run("clearActivation");

        def shape = getTypeVar("disabledShape", null);
        if( shape ) {
            self << shape;
        } else {
            self.remove(ShapeInfo);
        }
        self.remove(TriggerInfo);

        def gateLoc = self.location;
        world.setWorldCell(gateLoc, 0);
        world.setWorldCell(gateLoc.add(0, 1, 0), 0);

        self.remove(SoundInfo);
    }

    addAction("onActivate") { ->
        log.info("MG:activatePortals");
        getGatePortals(self).each { portal ->
            log.info("MG:spooling activate for:" + portal);
            spool {
                portal.run("activate");
            }
        }
    }

    addAction("onDeactivate") { ->
        log.info("MG:deactivatePortals");
        getGatePortals(self).each { portal ->
            portal.run("clearActivation");
        }
        // Should also clear any mob tags to this moon gate... though
        // usually they will remove on their own.
    }

    addAction("deactivatePortals") { ->
        log.info("remove me");
    }

    addAction("onTriggerApproached") { EntityId mob ->
        log.info("" + mob + " approached gate:" + self);
        if( chattyMoonGates ) {
            echo("You are approaching a " + self.name);
        }
        //gateApproached.call(session, self);
        return true;
    }

    addAction("onTriggerEntered") { EntityId mob ->
        log.info("" + mob + " entered gate:" + self);
        echo("You feel a surge of energy pulling you...");
        //echo("You have entered a " + self.name);
        log.info("MG:running activate on:" + self);
        run("activate");
        log.info("MG:done running activate on:" + self);
        tagPortalToMob(resolveEntityId(activator), self);
        //gateEntered.call(session, self);
        return true;
    }

    addAction("onTriggerExited") { EntityId mob ->
        log.info("" + mob + " exited gate:" + self);
        if( chattyMoonGates ) {
            echo("You have exited a " + self.name);
        }
        untagPortalToMob(resolveEntityId(activator), self, 3.0);
        //gateExited.call(session, self);
        createEntity(
            ScheduledAction.seconds(3, self, "deactivate")
        );
        return true;
    }

    addAction("onTriggerLeft") { EntityId mob ->
        log.info("" + mob + " left gate:" + self);
        if( chattyMoonGates ) {
            echo("You are leaving a " + self.name);
        }
        //gateLeaving.call(session, self);
        return true;
    }

    //addAction("Test Portal Connections") { ->
    //    buildPortalLinks.call(session, self);
    //}
}



