/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.bpos;

import com.simsilica.bpos.BodyPositionCache;
import com.simsilica.bpos.ChildPositionTransition3d;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityId;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.trans.Transition;
import com.simsilica.mathd.trans.TransitionBuffer;

public final class BodyPosition
implements EntityComponent {
    private transient int size;
    private transient TransitionBuffer<ChildPositionTransition3d> position;
    private transient ChildPositionTransition3d lastTransition;

    public BodyPosition() {
    }

    public BodyPosition(int history) {
        this.size = (byte)history;
        this.position = ChildPositionTransition3d.createChildBuffer(history);
    }

    public void initialize(EntityId id, int size) {
        if (this.position == null) {
            this.size = size;
            this.position = BodyPositionCache.getBuffer(id, size);
        }
    }

    public boolean isInitialized() {
        return this.position != null;
    }

    public TransitionBuffer<ChildPositionTransition3d> getBuffer() {
        return this.position;
    }

    public void addFrame(long endTime, Vec3d pos, Quatd quat, boolean visible) {
        this.addFrame(endTime, null, pos, quat, visible);
    }

    public void addFrame(long endTime, EntityId endParent, Vec3d pos, Quatd quat, boolean visible) {
        ChildPositionTransition3d trans = new ChildPositionTransition3d(endTime, endParent, pos, quat, visible);
        this.getBuffer().addTransition((Transition)trans);
        this.lastTransition = trans;
    }

    public ChildPositionTransition3d getFrame(long time) {
        return (ChildPositionTransition3d)this.getBuffer().getTransition(time);
    }

    public ChildPositionTransition3d getLastFrame() {
        return this.lastTransition;
    }

    public Vec3d getLastLocation() {
        if (this.lastTransition == null) {
            return null;
        }
        return this.lastTransition.getPosition(this.lastTransition.getEndTime(), true);
    }

    public Quatd getLastOrientation() {
        if (this.lastTransition == null) {
            return null;
        }
        return this.lastTransition.getRotation(this.lastTransition.getEndTime(), true);
    }

    public EntityId getLastParentId() {
        if (this.lastTransition == null) {
            return null;
        }
        return this.lastTransition.getParentId(this.lastTransition.getEndTime(), true);
    }

    public String toString() {
        return "BodyPosition[" + this.position + "]";
    }
}

