/*
 * Decompiled with CFR 0.152.
 */
package mythruna.mblock;

import com.jme3.math.Vector3f;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.Direction;
import com.simsilica.mblock.geom.BoundaryShape;
import com.simsilica.mblock.geom.BoundaryShapes;
import com.simsilica.mblock.geom.DefaultBlockFactory;
import com.simsilica.mblock.geom.DefaultPartFactory;
import com.simsilica.mblock.geom.GeomPart;
import com.simsilica.mblock.geom.GeomPartBuilder;
import com.simsilica.mblock.geom.MaterialType;
import com.simsilica.mblock.geom.PartFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThatchBlockFactory {
    static Logger log = LoggerFactory.getLogger(ThatchBlockFactory.class);
    private static Vec3d min = new Vec3d(0.0, 0.0, 0.0);
    private static Vec3d max = new Vec3d(1.0, 1.0, 1.0);
    private static final double[] transparency = new double[]{0.0, 0.0, 0.25, 0.25, 0.0, 0.0};
    private static final boolean[] solid = new boolean[]{false, false, false, false, false, false};

    public static DefaultBlockFactory createWedgeFactory(MaterialType mt) {
        GeomPart inside;
        GeomPart outside;
        GeomPart part = outside = new GeomPart(mt, -1, true);
        part.setCoords(new float[]{0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f});
        part.setNormals(new float[]{0.0f, 1.0f, 0.0f, 0.0f, 0.9806f, 0.1961f, 0.0f, 0.9806f, 0.1961f, 0.0f, 1.0f, 0.0f});
        part.setTangents(new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f});
        part.setTexCoords(new float[]{0.3f, 0.3f, 0.7f, 0.3f, 0.7f, 0.7f, 0.3f, 0.7f});
        part.setIndexes(new int[]{0, 1, 2, 0, 2, 3});
        float sqrt2 = (float)Math.sqrt(2.0);
        part = inside = new GeomPart(mt, -1, true);
        part.setCoords(new float[]{1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f});
        part.setNormals(new float[]{0.0f, -sqrt2, -sqrt2, 0.0f, -sqrt2, -sqrt2, 0.0f, -sqrt2, -sqrt2, 0.0f, -sqrt2, -sqrt2});
        part.setTangents(new float[]{-1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f});
        part.setTexCoords(new float[]{0.2f, 0.2f, 0.8f, 0.2f, 0.8f, 0.8f, 0.2f, 0.8f});
        part.setIndexes(new int[]{0, 1, 2, 0, 2, 3});
        DefaultPartFactory inner = new DefaultPartFactory(BoundaryShapes.NULL_SHAPE, min, max, new GeomPart[]{outside, inside});
        PartFactory[] parts = new PartFactory[6];
        part = outside = new GeomPart(mt, -1, true);
        part.setCoords(new float[]{1.0f, 1.0f, 0.0f, 1.1f, 0.59f, -0.1f, 0.0f, 1.0f, 0.0f, -0.1f, 0.61f, -0.1f});
        part.setNormals(new float[]{0.0f, 1.0f, 0.0f, 0.9901f, 0.099f, -0.099f, 0.0f, 1.0f, 0.0f, -0.9901f, 0.099f, -0.099f});
        part.setTangents(new float[]{-1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f});
        part.setTexCoords(new float[]{0.3f, 0.7f, 0.0f, 1.0f, 0.3f, 0.3f, 0.0f, 0.0f});
        part.setIndexes(new int[]{0, 1, 2, 2, 1, 3});
        part = inside = new GeomPart(mt, -1, true);
        part.setCoords(new float[]{1.0f, 1.0f, 0.0f, 1.1f, 0.59f, -0.1f, 0.0f, 1.0f, 0.0f, -0.1f, 0.61f, -0.1f});
        part.setNormals(new float[]{0.0f, -1.0f, 0.0f, -0.9901f, -0.099f, 0.099f, 0.0f, -1.0f, 0.0f, 0.9901f, -0.099f, 0.099f});
        part.setTangents(new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f});
        part.setTexCoords(new float[]{0.8f, 0.2f, 1.0f, 0.0f, 0.2f, 0.2f, 0.0f, 0.0f});
        part.setIndexes(new int[]{0, 2, 1, 2, 3, 1});
        parts[Direction.North.ordinal()] = new DefaultPartFactory(BoundaryShapes.UNIT_SQUARE, min, max, new GeomPart[]{outside, inside});
        part = outside = new GeomPart(mt, -1, true);
        part.setCoords(new float[]{0.0f, 0.0f, 1.0f, -0.1f, -0.9f, 1.2f, 1.0f, 0.0f, 1.0f, 1.1f, -0.9f, 1.1f});
        part.setNormals(new float[]{0.0f, 0.9806f, 0.1961f, -0.9901f, -0.099f, 0.099f, 0.0f, 0.9806f, 0.1961f, 0.9901f, -0.099f, 0.099f});
        part.setTangents(new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f});
        part.setTexCoords(new float[]{0.7f, 0.3f, 1.0f, 0.0f, 0.7f, 0.7f, 1.0f, 1.0f});
        part.setIndexes(new int[]{0, 1, 2, 2, 1, 3});
        part = inside = new GeomPart(mt, -1, true);
        part.setCoords(new float[]{0.0f, 0.0f, 1.0f, -0.1f, -0.9f, 1.2f, 1.0f, 0.0f, 1.0f, 1.1f, -0.9f, 1.1f});
        part.setNormals(new float[]{0.0f, -0.9806f, -0.1961f, 0.9901f, 0.099f, -0.099f, 0.0f, -0.9806f, -0.1961f, -0.9901f, 0.099f, -0.099f});
        part.setTangents(new float[]{-1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f});
        part.setTexCoords(new float[]{0.2f, 0.8f, 0.0f, 1.0f, 0.8f, 0.8f, 1.0f, 1.0f});
        part.setIndexes(new int[]{0, 2, 1, 2, 3, 1});
        parts[Direction.South.ordinal()] = new DefaultPartFactory(BoundaryShapes.NULL_SHAPE, min, max, new GeomPart[]{outside, inside});
        Vector3f normal = new Vector3f(0.0f, 1.0f, 1.0f).normalizeLocal();
        BoundaryShape triangle = BoundaryShapes.getTriangle((double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)normal.z, (double)normal.y);
        part = outside = new GeomPart(mt, -1, true);
        part.setCoords(new float[]{1.1f, -0.9f, 1.1f, 1.3f, 0.19f, -0.3f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f});
        part.setNormals(new float[]{0.9901f, -0.099f, 0.099f, 0.9901f, 0.099f, -0.099f, 0.0f, 1.0f, 0.0f, 0.0f, 0.9806f, 0.1961f});
        part.setTangents(new float[]{0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f});
        part.setTexCoords(new float[]{1.0f, 1.0f, 0.0f, 1.0f, 0.3f, 0.7f, 0.7f, 0.7f});
        part.setIndexes(new int[]{0, 1, 2, 3, 0, 2});
        part = inside = new GeomPart(mt, -1, true);
        part.setCoords(new float[]{1.1f, -0.9f, 1.1f, 1.3f, 0.19f, -0.3f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f});
        part.setNormals(new float[]{-0.9901f, 0.099f, -0.099f, -0.9901f, -0.099f, 0.099f, 0.0f, -1.0f, 0.0f, 0.0f, -0.9806f, -0.1961f});
        part.setTangents(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f});
        part.setTexCoords(new float[]{1.0f, 1.0f, 1.0f, 0.0f, 0.8f, 0.2f, 0.8f, 0.8f});
        part.setIndexes(new int[]{0, 2, 1, 3, 2, 0});
        parts[Direction.East.ordinal()] = new DefaultPartFactory(triangle, min, max, new GeomPart[]{outside, inside});
        part = outside = new GeomPart(mt, -1, true);
        part.setCoords(new float[]{0.0f, 1.0f, 0.0f, -0.1f, -0.9f, 1.2f, 0.0f, 0.0f, 1.0f, -0.3f, 0.21f, -0.3f});
        part.setNormals(new float[]{0.0f, 1.0f, 0.0f, -0.9901f, -0.099f, 0.099f, 0.0f, 0.9806f, 0.1961f, -0.9901f, 0.099f, -0.099f});
        part.setTangents(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f});
        part.setTexCoords(new float[]{0.3f, 0.3f, 1.0f, 0.0f, 0.7f, 0.3f, 0.0f, 0.0f});
        part.setIndexes(new int[]{0, 1, 2, 0, 3, 1});
        part = inside = new GeomPart(mt, -1, true);
        part.setCoords(new float[]{0.0f, 1.0f, 0.0f, -0.1f, -0.9f, 1.2f, 0.0f, 0.0f, 1.0f, -0.3f, 0.21f, -0.3f});
        part.setNormals(new float[]{0.0f, -1.0f, 0.0f, 0.9901f, 0.099f, -0.099f, 0.0f, -0.9806f, -0.1961f, 0.9901f, -0.099f, 0.099f});
        part.setTangents(new float[]{0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f});
        part.setTexCoords(new float[]{0.2f, 0.2f, 0.0f, 1.0f, 0.2f, 0.8f, 0.0f, 0.0f});
        part.setIndexes(new int[]{0, 2, 1, 0, 1, 3});
        parts[Direction.West.ordinal()] = new DefaultPartFactory(triangle, min, max, new GeomPart[]{outside, inside});
        double x = ThatchBlockFactory.max.x - ThatchBlockFactory.min.x;
        double y = ThatchBlockFactory.max.y - ThatchBlockFactory.min.y;
        double z = ThatchBlockFactory.max.z - ThatchBlockFactory.min.z;
        double volume = x * y * z;
        return new DefaultBlockFactory(parts, (PartFactory)inner, solid, transparency, volume, min, max);
    }

    public static GeomPart merge(GeomPart ... parts) {
        GeomPart part = new GeomPart(parts[0].getMaterialType());
        int vertCount = 0;
        int indexCount = 0;
        for (GeomPart p : parts) {
            vertCount += p.getVertexCount();
            indexCount += p.getIndexes().length;
        }
        float[] verts = new float[vertCount * 3];
        float[] norms = new float[vertCount * 3];
        float[] tans = new float[vertCount * 3];
        float[] texes = new float[vertCount * 2];
        short[] indexes = new short[indexCount];
        int baseCoord = 0;
        int base3 = 0;
        int base2 = 0;
        int indexIndex = 0;
        for (GeomPart p : parts) {
            System.arraycopy(p.getCoords(), 0, verts, base3, p.getCoords().length);
            System.arraycopy(p.getNormals(), 0, norms, base3, p.getNormals().length);
            System.arraycopy(p.getTangents(), 0, tans, base3, p.getTangents().length);
            System.arraycopy(p.getTexCoords(), 0, texes, base2, p.getTexCoords().length);
            base3 += p.getCoords().length;
            base2 += p.getTexCoords().length;
            short[] is = p.getIndexes();
            for (int i = 0; i < is.length; ++i) {
                indexes[indexIndex++] = (short)(is[i] + baseCoord);
            }
            baseCoord += p.getVertexCount();
        }
        part.setCoords(verts);
        part.setNormals(norms);
        part.setTangents(tans);
        part.setTexCoords(texes);
        part.setIndexes(indexes);
        return part;
    }

    public static DefaultBlockFactory createCornerFactory(MaterialType mt) {
        GeomPartBuilder pb = new GeomPartBuilder();
        pb.material(mt);
        pb.vertex(1.0, 1.0, 1.0).uv(0.3, 0.3).normal(0.0, 1.0, 0.0).tangent(-1.0, 0.0, 0.0);
        pb.vertex(1.0, 0.0, 0.0).uv(0.7, 0.3).normal(0.0, 0.9806, -0.1961).tangent(-1.0, 0.0, 0.0);
        pb.vertex(0.0, 0.0, 0.0).uv(0.7, 0.7).normal(-0.1925, 0.9623, -0.1925).tangent(-1.0, 0.0, 0.0);
        pb.indexes(0).set(new int[]{0, 1, 2});
        pb.vertex(1.0, 1.0, 1.0).uv(0.3, 0.3).normal(0.0, 1.0, 0.0).tangent(0.0, 0.0, 1.0);
        pb.vertex(0.0, 0.0, 0.0).uv(0.7, 0.7).normal(-0.1925, 0.9623, -0.1925).tangent(0.0, 0.0, 1.0);
        pb.vertex(0.0, 0.0, 1.0).uv(0.3, 0.7).normal(-0.1961, 0.9806, 0.0).tangent(0.0, 0.0, 1.0);
        pb.indexes(3).set(new int[]{0, 1, 2});
        GeomPart tops = pb.build();
        pb = new GeomPartBuilder();
        pb.material(mt);
        pb.vertex(1.0, 1.0, 1.0).uv(0.3, 0.3).normal(0.0, 1.0, 0.0).tangent(0.0, 0.0, -1.0);
        pb.vertex(1.1, -0.9, -0.2).uv(1.0, 0.0).normal(0.9901, -0.099, -0.099).tangent(0.0, 0.0, -1.0);
        pb.vertex(1.0, 0.0, 0.0).uv(0.7, 0.3).normal(0.0, 0.9806, -0.1961).tangent(0.0, 0.0, -1.0);
        pb.indexes(0).set(new int[]{0, 1, 2});
        pb.vertex(1.0, 1.0, 1.0).uv(0.3, 0.3).normal(0.0, 1.0, 0.0).tangent(0.0, 0.0, -1.0);
        pb.vertex(1.3, 0.21, 1.3).uv(0.0, 0.0).normal(0.7001, 0.14, 0.7001).tangent(0.0, 0.0, -1.0);
        pb.vertex(1.1, -0.9, -0.2).uv(1.0, 0.0).normal(0.9901, -0.099, -0.099).tangent(0.0, 0.0, -1.0);
        pb.indexes(3).set(new int[]{0, 1, 2});
        pb.vertex(1.0, 0.0, 0.0).uv(0.7, 0.3).normal(0.0, 0.9806, -0.1961).tangent(-1.0, 0.0, 0.0);
        pb.vertex(1.1, -0.9, -0.2).uv(1.0, 0.0).normal(0.9901, -0.099, -0.099).tangent(-1.0, 0.0, 0.0);
        pb.vertex(0.0, 0.0, 0.0).uv(0.7, 0.7).normal(-0.1925, 0.9623, -0.1925).tangent(-1.0, 0.0, 0.0);
        pb.indexes(6).set(new int[]{0, 1, 2});
        pb.vertex(0.0, 0.0, 0.0).uv(0.7, 0.7).normal(-0.1925, 0.9623, -0.1925).tangent(-1.0, 0.0, 0.0);
        pb.vertex(1.1, -0.9, -0.2).uv(1.0, 0.0).normal(0.9901, -0.099, -0.099).tangent(-1.0, 0.0, 0.0);
        pb.vertex(-0.1, -0.9, -0.1).uv(1.0, 1.0).normal(-0.6804, -0.2722, -0.6804).tangent(-1.0, 0.0, 0.0);
        pb.indexes(9).set(new int[]{0, 1, 2});
        pb.vertex(-0.1, -0.9, -0.1).uv(1.0, 1.0).normal(-0.6804, -0.2722, -0.6804).tangent(0.0, 0.0, 1.0);
        pb.vertex(-0.1, -0.9, 1.3).uv(0.0, 1.0).normal(-0.099, -0.099, 0.9901).tangent(0.0, 0.0, 1.0);
        pb.vertex(0.0, 0.0, 1.0).uv(0.3, 0.7).normal(-0.1961, 0.9806, 0.0).tangent(0.0, 0.0, 1.0);
        pb.indexes(12).set(new int[]{0, 1, 2});
        pb.vertex(0.0, 0.0, 0.0).uv(0.7, 0.7).normal(-0.1925, 0.9623, -0.1925).tangent(0.0, 0.0, 1.0);
        pb.vertex(-0.1, -0.9, -0.1).uv(1.0, 1.0).normal(-0.6804, -0.2722, -0.6804).tangent(0.0, 0.0, 1.0);
        pb.vertex(0.0, 0.0, 1.0).uv(0.3, 0.7).normal(-0.1961, 0.9806, 0.0).tangent(0.0, 0.0, 1.0);
        pb.indexes(15).set(new int[]{0, 1, 2});
        pb.vertex(1.0, 1.0, 1.0).uv(0.3, 0.3).normal(0.0, 1.0, 0.0).tangent(1.0, 0.0, 0.0);
        pb.vertex(0.0, 0.0, 1.0).uv(0.3, 0.7).normal(-0.1961, 0.9806, 0.0).tangent(1.0, 0.0, 0.0);
        pb.vertex(1.3, 0.21, 1.3).uv(0.0, 0.0).normal(0.7001, 0.14, 0.7001).tangent(1.0, 0.0, 0.0);
        pb.indexes(18).set(new int[]{0, 1, 2});
        pb.vertex(0.0, 0.0, 1.0).uv(0.3, 0.7).normal(-0.1961, 0.9806, 0.0).tangent(1.0, 0.0, 0.0);
        pb.vertex(-0.1, -0.9, 1.3).uv(0.0, 1.0).normal(-0.099, -0.099, 0.9901).tangent(1.0, 0.0, 0.0);
        pb.vertex(1.3, 0.21, 1.3).uv(0.0, 0.0).normal(0.7001, 0.14, 0.7001).tangent(1.0, 0.0, 0.0);
        pb.indexes(21).set(new int[]{0, 1, 2});
        GeomPart outsideFringe = pb.build();
        pb = new GeomPartBuilder();
        pb.material(mt);
        pb.vertex(1.0, 1.0, 1.0).uv(0.2, 0.2).normal(0.0, -1.0, 0.0).tangent(1.0, 0.0, 0.0);
        pb.vertex(0.0, 0.0, 0.0).uv(0.8, 0.8).normal(0.1925, -0.9623, 0.1925).tangent(1.0, 0.0, 0.0);
        pb.vertex(1.0, 0.0, 0.0).uv(0.2, 0.8).normal(0.0, -0.9806, 0.1961).tangent(1.0, 0.0, 0.0);
        pb.indexes(0).set(new int[]{0, 1, 2});
        pb.vertex(1.0, 1.0, 1.0).uv(0.2, 0.2).normal(0.0, -1.0, 0.0).tangent(0.0, 0.0, -1.0);
        pb.vertex(0.0, 0.0, 1.0).uv(0.8, 0.2).normal(0.1961, -0.9806, 0.0).tangent(0.0, 0.0, -1.0);
        pb.vertex(0.0, 0.0, 0.0).uv(0.8, 0.8).normal(0.1925, -0.9623, 0.1925).tangent(0.0, 0.0, -1.0);
        pb.indexes(3).set(new int[]{0, 1, 2});
        GeomPart bottoms = pb.build();
        pb = new GeomPartBuilder();
        pb.material(mt);
        pb.vertex(1.0, 1.0, 1.0).uv(0.2, 0.2).normal(0.0, -1.0, 0.0).tangent(0.0, 0.0, 1.0);
        pb.vertex(1.0, 0.0, 0.0).uv(0.2, 0.8).normal(0.0, -0.9806, 0.1961).tangent(0.0, 0.0, 1.0);
        pb.vertex(1.1, -0.9, -0.2).uv(0.0, 1.0).normal(-0.9901, 0.099, 0.099).tangent(0.0, 0.0, 1.0);
        pb.indexes(0).set(new int[]{0, 1, 2});
        pb.vertex(1.0, 1.0, 1.0).uv(0.2, 0.2).normal(0.0, -1.0, 0.0).tangent(0.0, 0.0, 1.0);
        pb.vertex(1.1, -0.9, -0.2).uv(0.0, 1.0).normal(-0.9901, 0.099, 0.099).tangent(0.0, 0.0, 1.0);
        pb.vertex(1.3, 0.21, 1.3).uv(0.0, 0.0).normal(-0.7001, -0.14, -0.7001).tangent(0.0, 0.0, 1.0);
        pb.indexes(3).set(new int[]{0, 1, 2});
        pb.vertex(1.0, 0.0, 0.0).uv(0.2, 0.8).normal(0.0, -0.9806, 0.1961).tangent(1.0, 0.0, 0.0);
        pb.vertex(0.0, 0.0, 0.0).uv(0.8, 0.8).normal(0.1925, -0.9623, 0.1925).tangent(1.0, 0.0, 0.0);
        pb.vertex(1.1, -0.9, -0.2).uv(0.0, 1.0).normal(-0.9901, 0.099, 0.099).tangent(1.0, 0.0, 0.0);
        pb.indexes(6).set(new int[]{0, 1, 2});
        pb.vertex(0.0, 0.0, 0.0).uv(0.8, 0.8).normal(0.1925, -0.9623, 0.1925).tangent(1.0, 0.0, 0.0);
        pb.vertex(-0.1, -0.9, -0.1).uv(1.0, 1.0).normal(0.6804, 0.2722, 0.6804).tangent(1.0, 0.0, 0.0);
        pb.vertex(1.1, -0.9, -0.2).uv(0.0, 1.0).normal(-0.9901, 0.099, 0.099).tangent(1.0, 0.0, 0.0);
        pb.indexes(9).set(new int[]{0, 1, 2});
        pb.vertex(-0.1, -0.9, -0.1).uv(1.0, 1.0).normal(0.6804, 0.2722, 0.6804).tangent(0.0, 0.0, -1.0);
        pb.vertex(0.0, 0.0, 1.0).uv(0.8, 0.2).normal(0.1961, -0.9806, 0.0).tangent(0.0, 0.0, -1.0);
        pb.vertex(-0.1, -0.9, 1.3).uv(1.0, 0.0).normal(0.099, 0.099, -0.9901).tangent(0.0, 0.0, -1.0);
        pb.indexes(12).set(new int[]{0, 1, 2});
        pb.vertex(0.0, 0.0, 0.0).uv(0.8, 0.8).normal(0.1925, -0.9623, 0.1925).tangent(0.0, 0.0, -1.0);
        pb.vertex(0.0, 0.0, 1.0).uv(0.8, 0.2).normal(0.1961, -0.9806, 0.0).tangent(0.0, 0.0, -1.0);
        pb.vertex(-0.1, -0.9, -0.1).uv(1.0, 1.0).normal(0.6804, 0.2722, 0.6804).tangent(0.0, 0.0, -1.0);
        pb.indexes(15).set(new int[]{0, 1, 2});
        pb.vertex(1.0, 1.0, 1.0).uv(0.2, 0.2).normal(0.0, -1.0, 0.0).tangent(-1.0, 0.0, 0.0);
        pb.vertex(1.3, 0.21, 1.3).uv(0.0, 0.0).normal(-0.7001, -0.14, -0.7001).tangent(-1.0, 0.0, 0.0);
        pb.vertex(0.0, 0.0, 1.0).uv(0.8, 0.2).normal(0.1961, -0.9806, 0.0).tangent(-1.0, 0.0, 0.0);
        pb.indexes(18).set(new int[]{0, 1, 2});
        pb.vertex(0.0, 0.0, 1.0).uv(0.8, 0.2).normal(0.1961, -0.9806, 0.0).tangent(-1.0, 0.0, 0.0);
        pb.vertex(1.3, 0.21, 1.3).uv(0.0, 0.0).normal(-0.7001, -0.14, -0.7001).tangent(-1.0, 0.0, 0.0);
        pb.vertex(-0.1, -0.9, 1.3).uv(1.0, 0.0).normal(0.099, 0.099, -0.9901).tangent(-1.0, 0.0, 0.0);
        pb.indexes(21).set(new int[]{0, 1, 2});
        GeomPart insideFringe = pb.build();
        double x = ThatchBlockFactory.max.x - ThatchBlockFactory.min.x;
        double y = ThatchBlockFactory.max.y - ThatchBlockFactory.min.y;
        double z = ThatchBlockFactory.max.z - ThatchBlockFactory.min.z;
        double volume = x * y * z;
        GeomPart part = pb.build();
        log.info("Created part:" + part);
        log.info(" caps:" + part.calculateGeomCaps());
        DefaultPartFactory inner = new DefaultPartFactory(BoundaryShapes.NULL_SHAPE, min, max, new GeomPart[]{tops, outsideFringe, bottoms, insideFringe});
        return new DefaultBlockFactory(null, (PartFactory)inner, solid, transparency, volume, min, max);
    }
}

