/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class Log4j2LevelConverter {
    private static final Set<Logger> keepAlive = new HashSet<Logger>();
    private static final Map<Level, java.util.logging.Level> toJul = new HashMap<Level, java.util.logging.Level>();

    public static void convert() {
        LoggerContext logContext = (LoggerContext)LogManager.getContext((boolean)false);
        Map map = logContext.getConfiguration().getLoggers();
        for (LoggerConfig config : map.values()) {
            System.out.println("logger config:" + config);
            Log4j2LevelConverter.setJulLevel(config.getName(), config.getLevel());
        }
    }

    protected static void setJulLevel(String logger, Level level) {
        java.util.logging.Level newLevel = toJul.get(level);
        System.out.println("Setting JUL Log:" + logger + " level to:" + newLevel);
        Logger l = Logger.getLogger(logger);
        if (l == null) {
            System.err.println("WARN: No logger found for:" + logger);
            return;
        }
        l.setLevel(newLevel);
        keepAlive.add(l);
    }

    static {
        toJul.put(Level.OFF, java.util.logging.Level.OFF);
        toJul.put(Level.FATAL, java.util.logging.Level.SEVERE);
        toJul.put(Level.ERROR, java.util.logging.Level.SEVERE);
        toJul.put(Level.WARN, java.util.logging.Level.WARNING);
        toJul.put(Level.INFO, java.util.logging.Level.INFO);
        toJul.put(Level.DEBUG, java.util.logging.Level.FINE);
        toJul.put(Level.TRACE, java.util.logging.Level.FINER);
        toJul.put(Level.ALL, java.util.logging.Level.FINEST);
    }
}

