/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.sql;

import com.simsilica.es.sql.FieldType;
import com.simsilica.es.sql.FieldTypes;
import com.simsilica.es.sql.SqlComponentFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class DefaultComponentFactory<T>
implements SqlComponentFactory<T> {
    private final FieldType[] fields;
    private final Constructor<T> ctor;

    public DefaultComponentFactory(Class<T> type) {
        List<FieldType> types = FieldTypes.getFieldTypes(type);
        this.fields = types.toArray(new FieldType[types.size()]);
        try {
            this.ctor = type.getDeclaredConstructor(new Class[0]);
            this.ctor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Type does not have a no-arg constructor:" + type, e);
        }
    }

    @Override
    public FieldType[] getFieldTypes() {
        return this.fields;
    }

    @Override
    public T createComponent(ResultSet rs) throws SQLException {
        try {
            int index = 1;
            T target = this.ctor.newInstance(new Object[0]);
            for (FieldType t : this.fields) {
                index = t.load(target, rs, index);
            }
            return target;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Error in table mapping", e);
        }
    }
}

