/*
 * Decompiled with CFR 0.152.
 */
package mythruna.text;

import com.google.common.base.MoreObjects;
import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionedExpression
implements VersionedObject<String> {
    static Logger log = LoggerFactory.getLogger(VersionedExpression.class);
    private static final Pattern PARAMETERS = Pattern.compile("(?<!\\\\)\\$(\\w+)|\\$\\{(.*?)\\}");
    private String text;
    private List<Part> parts = new ArrayList<Part>();
    private long version;
    private String joined;

    public VersionedExpression(String text) {
        this.text = text;
        this.parse(text);
    }

    protected void invalidate() {
        ++this.version;
        this.joined = null;
    }

    public void setExpression(String text) {
        if (Objects.equals(this.text, text)) {
            return;
        }
        this.text = text;
        this.parse(text);
        this.invalidate();
    }

    public String getExpression() {
        return this.text;
    }

    public boolean update(Map<String, Supplier<Object>> values) {
        boolean changed = false;
        for (Part p : this.parts) {
            if (!p.update(values)) continue;
            changed = true;
        }
        if (changed) {
            this.invalidate();
        }
        return changed;
    }

    public long getVersion() {
        return this.version;
    }

    public String getObject() {
        if (this.joined == null) {
            StringBuilder sb = new StringBuilder();
            for (Part p : this.parts) {
                sb.append(p.getValue());
            }
            this.joined = sb.toString();
        }
        return this.joined;
    }

    public VersionedReference<String> createReference() {
        return new VersionedReference((VersionedObject)this);
    }

    protected void parse(String text) {
        this.parts.clear();
        if (text == null) {
            return;
        }
        Matcher m = PARAMETERS.matcher(text);
        int start = 0;
        while (m.find()) {
            String key;
            if (m.start() > start) {
                this.parts.add(new IdentityPart(this, text.substring(start, m.start())));
            }
            if ((key = m.group(1)) == null) {
                key = m.group(2);
            }
            this.parts.add(new VariablePart(this, key));
            start = m.end();
        }
        if (start < text.length()) {
            this.parts.add(new IdentityPart(this, text.substring(start)));
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("parts", this.parts).add("version", this.version).toString();
    }

    private static interface Part {
        public String getValue();

        default public boolean update(Map<String, Supplier<Object>> values) {
            return false;
        }
    }

    private class IdentityPart
    implements Part {
        private String value;

        public IdentityPart(VersionedExpression versionedExpression, String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.value + "]";
        }
    }

    private class VariablePart
    implements Part {
        private String key;
        private Object value;

        public VariablePart(VersionedExpression versionedExpression, String key) {
            this.key = key;
        }

        @Override
        public boolean update(Map<String, Supplier<Object>> values) {
            String newValue;
            Supplier<Object> supplier = values.get(this.key);
            String string = newValue = supplier == null ? null : String.valueOf(supplier.get());
            if (!Objects.equals(this.value, newValue)) {
                this.value = newValue;
                return true;
            }
            return false;
        }

        @Override
        public String getValue() {
            return String.valueOf(this.value);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.key + "]";
        }
    }
}

