/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResults;
import com.jme3.math.Ray;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.Button;
import com.simsilica.lemur.EmptyAction;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.OptionPanelState;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.post.DefaultSceneProcessor;
import java.util.function.Consumer;
import mythruna.client.ErrorDialog;
import mythruna.client.PerspectiveGuiState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(GuiState.class);
    private Node guiRoot = new Node("guiRoot");
    private VersionedHolder<Vector2f> guiSize = new VersionedHolder((Object)new Vector2f(1600.0f, 900.0f));
    private VersionedHolder<Float> standardScale = new VersionedHolder((Object)Float.valueOf(1.0f));
    private ReshapeListener reshapeListener = new ReshapeListener();
    private boolean sizeInvalid;

    public VersionedReference<Float> createStandardScaleReference() {
        return this.standardScale.createReference();
    }

    public VersionedReference<Vector2f> createGuiSizeReference() {
        return this.guiSize.createReference();
    }

    public void center(Panel p) {
        Vector3f pref = p.getPreferredSize().mult(p.getLocalScale().x);
        Vector2f loc = ((Vector2f)this.guiSize.getObject()).mult(0.5f);
        loc.addLocal(-pref.x * 0.5f, pref.y * 0.5f);
        p.setLocalTranslation(loc.x, loc.y, p.getLocalTranslation().z);
    }

    public Node getGuiRoot() {
        return this.guiRoot;
    }

    public float getStandardScale() {
        return ((Float)this.standardScale.getObject()).floatValue();
    }

    public Vector2f getGuiSize() {
        return (Vector2f)this.guiSize.getObject();
    }

    public void showError(String title, String error, Throwable t) {
        if (error.indexOf("\n") > 0) {
            String[] lines = error.split("[\\r\\n]+");
            error = lines[0];
        }
        if (error.length() > 80) {
            StringBuilder sb = new StringBuilder();
            int pos = 0;
            while (pos < error.length()) {
                int next = Math.min(error.length(), pos + 80);
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(error.substring(pos, next));
                pos = next;
            }
            error = sb.toString();
        }
        if (t != null) {
            ((OptionPanelState)this.getState(OptionPanelState.class)).show(title, error, new Action[]{new DetailsAction(this, "Details", error, t), new ReportAction("Report", error, t), new EmptyAction("Close")});
        } else {
            ((OptionPanelState)this.getState(OptionPanelState.class)).show(title, error, new Action[0]);
        }
    }

    public int pickScreen(Vector2f pos, CollisionResults results) {
        Ray ray = new Ray(new Vector3f(pos.x, pos.y, 10000.0f), new Vector3f(0.0f, 0.0f, -1.0f));
        return this.guiRoot.collideWith((Collidable)ray, results);
    }

    public Vector2f screenToUi(Vector2f pos) {
        float scale = ((Float)this.standardScale.getObject()).floatValue();
        return pos.divide(scale);
    }

    protected Node getGuiNode() {
        return ((PerspectiveGuiState)this.getState(PerspectiveGuiState.class)).getRawGlassRoot();
    }

    protected ViewPort getHudViewPort() {
        return this.getApplication().getGuiViewPort();
    }

    protected void initialize(Application app) {
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        GuiGlobals.getInstance().getPopupState().setGuiNode(this.guiRoot);
        this.getHudViewPort().addProcessor((SceneProcessor)this.reshapeListener);
        this.getGuiNode().attachChild((Spatial)this.guiRoot);
        this.resetScreenSize();
    }

    public void update(float tpf) {
        if (this.sizeInvalid) {
            this.resetScreenSize();
        }
    }

    protected void onDisable() {
        this.getHudViewPort().removeProcessor((SceneProcessor)this.reshapeListener);
        GuiGlobals.getInstance().getPopupState().setGuiNode(this.getGuiNode());
        this.guiRoot.removeFromParent();
    }

    protected void resetScreenSize() {
        log.trace("resetScreenSize()");
        int width = this.getApplication().getCamera().getWidth();
        int height = this.getApplication().getCamera().getHeight();
        float scale = (float)height / 900.0f;
        float aspect = (float)width / (float)height;
        this.guiRoot.setLocalScale(scale, scale, 1.0f);
        this.standardScale.updateObject((Object)Float.valueOf(scale));
        this.guiSize.updateObject((Object)new Vector2f(900.0f * aspect, 900.0f));
        this.sizeInvalid = false;
    }

    private class ReshapeListener
    extends DefaultSceneProcessor {
        private ReshapeListener() {
        }

        public void reshape(ViewPort vp, int w, int h) {
            if (log.isTraceEnabled()) {
                log.trace("reshape(" + vp + ", " + w + ", " + h + ")");
            }
            GuiState.this.sizeInvalid = true;
        }
    }

    protected class DetailsAction
    extends Action {
        private String message;
        private Throwable throwable;

        public DetailsAction(GuiState this$0, String name, String message, Throwable throwable) {
            super(name);
            this.message = message;
            this.throwable = throwable;
        }

        public void execute(Button b) {
            log.info("Show details...");
            ErrorDialog dialog = new ErrorDialog(this.message, this.throwable, null);
            dialog.setVisible(true);
        }
    }

    protected class ReportAction
    extends Action {
        private String message;
        private Throwable throwable;

        public ReportAction(String name, String message, Throwable throwable) {
            super(name);
            this.message = message;
            this.throwable = throwable;
        }

        public void execute(Button b) {
            log.info("Generating report...");
            ErrorDialog dialog = new ErrorDialog(this.message, this.throwable, null);
            Consumer<Integer> progress = p -> System.out.println("progress:" + p);
            dialog.generateReportZip(progress, (msg, t) -> {
                if (t != null) {
                    log.error(msg, t);
                } else {
                    log.info(msg);
                }
                ((OptionPanelState)GuiState.this.getState(OptionPanelState.class)).show("Generate Report", msg, new Action[0]);
            });
        }
    }
}

