/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.net.character;

import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityCriteria;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.thread.Job;
import com.simsilica.thread.JobState;
import java.util.HashMap;
import java.util.Map;
import mythruna.character.ClothingTemplateIndex;
import mythruna.es.ClothingInfo;
import mythruna.es.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvailableClothing
implements VersionedObject<AvailableClothing> {
    static Logger log = LoggerFactory.getLogger(AvailableClothing.class);
    private long version = 0L;
    private EntityData ed;
    private EntityId worldEntity;
    private ClothingTemplateIndex templateIndex;
    private ClothingShapeContainer shapes;
    private Map<String, String> clothingShapes = new HashMap<String, String>();
    private JobState jobState;

    public AvailableClothing(EntityData ed, EntityId worldEntity, ClothingTemplateIndex templateIndex, JobState jobState) {
        this.ed = ed;
        this.worldEntity = worldEntity;
        this.templateIndex = templateIndex;
        this.shapes = new ClothingShapeContainer(ed, worldEntity);
        this.jobState = jobState;
    }

    public long getVersion() {
        return this.version;
    }

    public AvailableClothing getObject() {
        return this;
    }

    public VersionedReference<AvailableClothing> createReference() {
        return new VersionedReference((VersionedObject)this);
    }

    public String getClothingShape(String infoName) {
        return this.clothingShapes.get(infoName);
    }

    public ClothingTemplateIndex getClothingTemplateIndex() {
        return this.templateIndex;
    }

    public void start() {
        log.trace("start()");
        this.shapes.start();
    }

    public void update() {
        this.shapes.update();
    }

    public void stop() {
        log.trace("stop()");
        this.shapes.stop();
    }

    protected void indexShape(ClothingShape shape) {
        if (log.isTraceEnabled()) {
            log.trace("indexShape(" + shape + ")");
        }
        this.clothingShapes.put(shape.infoName, shape.shapeName);
        ++this.version;
    }

    protected class ClothingShapeContainer
    extends EntityContainer<ClothingShape> {
        public ClothingShapeContainer(EntityData ed, EntityId worldEntity) {
            super(ed, new EntityCriteria().set(Filters.fieldEquals(ClothingInfo.class, (String)"parent", (Object)worldEntity), new Class[]{ClothingInfo.class, ObjectName.class, ShapeInfo.class}));
        }

        protected ClothingShape[] getArray() {
            return (ClothingShape[])super.getArray();
        }

        protected ClothingShape addObject(Entity entity) {
            if (log.isTraceEnabled()) {
                log.trace("addObject(" + entity.getId() + ")");
            }
            ClothingShape object = new ClothingShape(entity);
            AvailableClothing.this.jobState.execute((Job)object, 0);
            return object;
        }

        protected void updateObject(ClothingShape object, Entity entity) {
            if (log.isTraceEnabled()) {
                log.trace("updateObject(" + entity.getId() + ")");
            }
        }

        protected void removeObject(ClothingShape object, Entity entity) {
            if (log.isTraceEnabled()) {
                log.trace("removeObject(" + entity.getId() + ")");
            }
        }
    }

    protected class ClothingShape
    implements Job {
        private Entity entity;
        private volatile String infoName;
        private volatile String objectName;
        private volatile String shapeName;

        public ClothingShape(Entity entity) {
            this.entity = entity;
        }

        public void runOnWorker() {
            ObjectName on = (ObjectName)this.entity.get(ObjectName.class);
            ClothingInfo info = (ClothingInfo)this.entity.get(ClothingInfo.class);
            ShapeInfo shapeInfo = (ShapeInfo)this.entity.get(ShapeInfo.class);
            this.infoName = info.getName();
            this.shapeName = shapeInfo.getShapeName(AvailableClothing.this.ed);
        }

        public double runOnUpdate() {
            AvailableClothing.this.indexShape(this);
            return 0.0;
        }

        public String toString() {
            return "ClothingShape[entity:" + this.entity + ", infoName:" + this.infoName + ", objectName:" + this.objectName + ", shapeName:" + this.shapeName + "]";
        }
    }
}

