/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.event;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.input.RawInputListener;
import com.jme3.input.event.KeyInputEvent;
import com.jme3.util.SafeArrayList;
import com.simsilica.lemur.event.DefaultRawInputListener;
import com.simsilica.lemur.event.KeyListener;
import com.simsilica.lemur.event.ModifiedKeyInputEvent;

public class KeyInterceptState
extends BaseAppState {
    private KeyObserver keyObserver = new KeyObserver();
    private int modifiers;
    private SafeArrayList<KeyListener> keyListeners = new SafeArrayList(KeyListener.class);

    public KeyInterceptState(Application app) {
        this.setEnabled(true);
        app.getInputManager().addRawInputListener((RawInputListener)this.keyObserver);
    }

    public void addKeyListener(KeyListener l) {
        this.keyListeners.add((Object)l);
    }

    public void removeKeyListener(KeyListener l) {
        this.keyListeners.remove((Object)l);
    }

    protected void initialize(Application app) {
    }

    protected void cleanup(Application app) {
        app.getInputManager().removeRawInputListener((RawInputListener)this.keyObserver);
    }

    protected void onEnable() {
    }

    protected void onDisable() {
    }

    protected void setModifier(int mask, boolean on) {
        this.modifiers = on ? (this.modifiers |= mask) : (this.modifiers &= ~mask);
    }

    protected void dispatch(KeyInputEvent evt) {
        if (!this.isEnabled()) {
            return;
        }
        int code = evt.getKeyCode();
        if (code == 42 || code == 54) {
            this.setModifier(2, evt.isPressed());
        }
        if (code == 29 || code == 157) {
            this.setModifier(1, evt.isPressed());
        }
        if (code == 56 || code == 184) {
            this.setModifier(4, evt.isPressed());
        }
        ModifiedKeyInputEvent wrapper = null;
        for (KeyListener l : (KeyListener[])this.keyListeners.getArray()) {
            if (wrapper == null) {
                wrapper = new ModifiedKeyInputEvent(evt, this.modifiers);
            }
            l.onKeyEvent(wrapper);
        }
    }

    protected class KeyObserver
    extends DefaultRawInputListener {
        protected KeyObserver() {
        }

        @Override
        public void onKeyEvent(KeyInputEvent evt) {
            KeyInterceptState.this.dispatch(evt);
        }
    }
}

