/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile.morph;

import com.simsilica.ethereal.io.BitInputStream;
import com.simsilica.ethereal.io.BitOutputStream;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.io.ObjectProtocol;
import com.simsilica.mworld.tile.morph.BoxFill;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoxFillProtocol
implements ObjectProtocol<BoxFill> {
    static Logger log = LoggerFactory.getLogger(BoxFillProtocol.class);
    public static final int X_BITS = 32;
    public static final int Y_BITS = 10;
    public static final int Z_BITS = 32;
    public static final int BLOCK_FILL_BITS = 16;
    public static final int TERRAIN_FILL_BITS = 16;
    private int version = 0;

    @Override
    public int getProtocolVersion() {
        return this.version;
    }

    @Override
    public void write(BoxFill data, BitOutputStream out) throws IOException {
        out.writeBits(this.version, 8);
        Vec3i min = data.getMin();
        Vec3i max = data.getMax();
        out.writeBits(min.x, 32);
        out.writeBits(min.y, 10);
        out.writeBits(min.z, 32);
        out.writeBits(max.x, 32);
        out.writeBits(max.y, 10);
        out.writeBits(max.z, 32);
        out.writeBits(data.getBlockFill(), 16);
        out.writeBits((int)data.getTerrainFill(), 16);
    }

    @Override
    public BoxFill read(BitInputStream in) throws IOException {
        int version = in.readBits(8);
        int x = in.readBits(32);
        int y = in.readBits(10);
        int z = in.readBits(32);
        Vec3i min = new Vec3i(x, y, z);
        x = in.readBits(32);
        y = in.readBits(10);
        z = in.readBits(32);
        Vec3i max = new Vec3i(x, y, z);
        int blockFill = in.readBits(16);
        byte terrainFill = (byte)in.readBits(16);
        return new BoxFill(min, max, blockFill, terrainFill);
    }
}

