/*
 * Decompiled with CFR 0.152.
 */
package mythruna.character;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import mythruna.character.RaceType;
import mythruna.text.CsvUtils;
import mythruna.text.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaceTypeIndex {
    static Logger log = LoggerFactory.getLogger(RaceTypeIndex.class);
    public static final String RACE_INDEX_CSV = "races/race-index.csv";
    private Map<String, RaceType> index = new LinkedHashMap<String, RaceType>();

    public RaceTypeIndex(List<RaceType> races) {
        for (RaceType race : races) {
            if (!race.isEnabled()) continue;
            this.index.put(race.getBaseId(), race);
        }
    }

    public RaceType getRace(String baseId) {
        return this.index.get(baseId);
    }

    public Collection<RaceType> getRaces() {
        return this.index.values();
    }

    public void populateText(Function<String, String> textFunc) {
        for (RaceType type : this.index.values()) {
            type.populateText(textFunc);
        }
    }

    public static RaceTypeIndex create(Function<String, String> textFunc, boolean populateText) {
        String text = textFunc.apply(RACE_INDEX_CSV);
        RaceTypeIndex index = RaceTypeIndex.create(text);
        if (populateText) {
            index.populateText(textFunc);
        }
        return index;
    }

    public static RaceTypeIndex create(String text) {
        List<Map<String, String>> records = CsvUtils.csvToRecords(text, 0, '\t');
        List<RaceType> races = MapUtils.toObjects(records, RaceType.class);
        return new RaceTypeIndex(races);
    }
}

