/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ethereal.net;

import com.jme3.network.HostedConnection;
import com.jme3.network.Message;
import com.simsilica.ethereal.ConnectionStats;
import com.simsilica.ethereal.TimeSource;
import com.simsilica.ethereal.net.FrameState;
import com.simsilica.ethereal.net.ObjectState;
import com.simsilica.ethereal.net.ObjectStateMessage;
import com.simsilica.ethereal.net.ObjectStateProtocol;
import com.simsilica.ethereal.net.SentState;
import com.simsilica.ethereal.zone.ZoneKey;
import com.simsilica.mathd.util.IntRange;
import com.simsilica.mathd.util.IntRangeSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateWriter {
    static Logger log = LoggerFactory.getLogger(StateWriter.class);
    private final HostedConnection conn;
    private final ObjectStateProtocol objectProtocol;
    private final LinkedList<SentState> sentStates = new LinkedList();
    private final IntRangeSet receivedAcks = new IntRangeSet();
    private IntRange[] receivedAcksArray = null;
    private long frameTime;
    private long legacySequence;
    private ZoneKey centerZone;
    private long centerZoneId;
    private FrameState currentFrame;
    private static final int UDP_HEADER = 50;
    private static final int SM_HEADER = 5;
    private int mtu = 1500;
    private int bufferSize = this.mtu - 50 - 5;
    private SentState outbound;
    private int nextMessageId = 0;
    private int headerBits;
    private int estimatedSize;
    private TimeSource timeSource;
    private ConnectionStats stats;
    private int mostRecentAckedMessageId;
    private int maxMessageDelta;
    private int messagesPerFrame;

    public StateWriter(HostedConnection conn, ObjectStateProtocol objectProtocol, TimeSource timeSource, ConnectionStats stats) {
        this.conn = conn;
        this.objectProtocol = objectProtocol;
        this.timeSource = timeSource;
        this.stats = stats;
    }

    public void setMaxMessageSize(int max) {
        this.mtu = max;
        this.bufferSize = this.mtu - 50 - 5;
    }

    public int getMaxMessageSize() {
        return this.mtu;
    }

    public SentState ackSentState(int messageId) {
        if (log.isTraceEnabled()) {
            log.trace("ackSentState(" + messageId + ")");
            log.trace("  sentStates.size():" + this.sentStates.size() + "  recAcks.size():" + this.receivedAcks.size());
        }
        if (messageId > this.mostRecentAckedMessageId) {
            if (log.isTraceEnabled()) {
                log.trace("updating mostRecentAckedMessageId to:" + messageId);
            }
            this.mostRecentAckedMessageId = messageId;
        }
        if (this.sentStates.isEmpty()) {
            return null;
        }
        Iterator it = this.sentStates.iterator();
        while (it.hasNext()) {
            SentState s = (SentState)it.next();
            if (log.isTraceEnabled()) {
                log.trace("  checking:" + s.messageId + " and " + messageId);
            }
            if (s.messageId == messageId) {
                if (log.isTraceEnabled()) {
                    log.trace("     found:" + messageId);
                }
                if (s.acked != null) {
                    for (IntRange ack : s.acked) {
                        boolean b = this.receivedAcks.remove(ack);
                        if (b && log.isTraceEnabled()) {
                            log.trace("       removed recvd acks:" + ack);
                        }
                        this.receivedAcksArray = null;
                    }
                }
                if (log.isTraceEnabled()) {
                    log.trace("       adding recvd ack:" + messageId);
                }
                this.receivedAcks.add(messageId);
                this.receivedAcksArray = null;
                it.remove();
                return s;
            }
            if (messageId < s.messageId) {
                log.info("messageId:" + messageId + " is earlier than s.messageId:" + s.messageId);
                return null;
            }
            if (log.isTraceEnabled()) {
                log.trace("    expiring:" + s.messageId);
            }
            if (log.isInfoEnabled()) {
                log.info("Removing old unmatched message:" + s.messageId);
            }
            it.remove();
        }
        return null;
    }

    public void startFrame(long time, ZoneKey centerZone) throws IOException {
        long delta = Math.abs(time - this.timeSource.getTime());
        if (delta > 1000000000L) {
            log.warn("Mismatched time sources.  Delta:" + (double)delta / 1.0E9 + " seconds");
        }
        this.endFrame();
        this.messagesPerFrame = 0;
        this.startMessage();
        this.frameTime = time;
        this.centerZone = centerZone;
        this.centerZoneId = centerZone != null ? centerZone.toLongId() : -1L;
        this.legacySequence = time & 0xFFFFFFFFFFFF00L;
    }

    public void addState(ObjectState state) throws IOException {
        if (this.currentFrame == null) {
            if (this.frameTime == 0L) {
                throw new IllegalStateException("Frame time is 0 as if not initialized.");
            }
            this.currentFrame = new FrameState(this.frameTime, this.legacySequence++, this.centerZoneId);
        }
        this.currentFrame.addState(state, this.objectProtocol);
    }

    protected void startMessage() {
        int size;
        if (this.outbound != null) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("startMessage() frameTime:" + this.frameTime);
        }
        ++this.messagesPerFrame;
        int msgDelta = this.nextMessageId - this.mostRecentAckedMessageId;
        if (msgDelta > this.maxMessageDelta) {
            this.maxMessageDelta = msgDelta;
        }
        if (this.receivedAcksArray == null) {
            this.receivedAcksArray = this.receivedAcks.toRangeArray();
        }
        if (this.receivedAcksArray.length == 1) {
            size = this.receivedAcks.size();
            if (log.isTraceEnabled()) {
                log.trace("startMessage() -> receivedAcks.size():" + size + " mostRecentAckedMessageId:" + this.mostRecentAckedMessageId + "  nextMessageID:" + this.nextMessageId + " difference:" + msgDelta + "  max diff:" + this.maxMessageDelta);
            }
            if (size - this.maxMessageDelta >= 128) {
                log.error("Very bad things have happened in the receivedAcks set, size:" + size + "  maxMessageDelta:" + this.maxMessageDelta);
            }
        } else if (this.receivedAcksArray.length > 128) {
            log.warn("Received acks set is getting very fragmented, number of ranges:" + this.receivedAcksArray.length);
            if (log.isTraceEnabled()) {
                size = this.receivedAcks.size();
                log.trace("startMessage() -> receivedAcks.size():" + size + " mostRecentAckedMessageId:" + this.mostRecentAckedMessageId + "  nextMessageID:" + this.nextMessageId + " difference:" + msgDelta + "  max diff:" + this.maxMessageDelta);
            }
        } else if (this.receivedAcksArray.length > 255) {
            throw new RuntimeException("Highly fragmented received ACKs ranges:" + this.receivedAcksArray.length + " Very bad things have happened in the receivedAcks set.");
        }
        this.outbound = new SentState(-1, this.receivedAcksArray, new ArrayList<FrameState>());
        this.headerBits = this.outbound.getEstimatedHeaderSize();
        int bytes = this.headerBits / 8;
        if (bytes > this.bufferSize) {
            log.error("State header size exceeds max buffer size, including:" + this.receivedAcksArray.length + " recvd ACK ranges.");
        } else if (bytes > this.bufferSize / 2) {
            log.warn("State header size exceeds half max buffer size, including:" + this.receivedAcksArray.length + " recvd ACK ranges.");
        }
        this.estimatedSize = this.headerBits;
    }

    protected void endFrame() throws IOException {
        long bitsRemaining;
        if (this.currentFrame == null) {
            return;
        }
        if (this.outbound == null) {
            throw new RuntimeException("endFrame() called without an open startMessage()");
        }
        long frameSize = this.currentFrame.getEstimatedBitSize() + 1L;
        if (frameSize < (bitsRemaining = (long)(this.bufferSize * 8 - this.estimatedSize))) {
            this.outbound.frames.add(this.currentFrame);
            this.estimatedSize = (int)((long)this.estimatedSize + frameSize);
            this.currentFrame = null;
            if (log.isTraceEnabled()) {
                log.trace("frame in size remaining.  Messages per frame:" + this.messagesPerFrame);
            }
            return;
        }
        FrameState frame = this.currentFrame;
        while (frame != null) {
            if (!this.outbound.frames.isEmpty()) {
                this.endMessage();
            }
            this.startMessage();
            bitsRemaining = this.bufferSize * 8 - this.estimatedSize;
            FrameState split = frame.split(bitsRemaining, this.objectProtocol);
            this.outbound.frames.add(frame);
            frameSize = frame.getEstimatedBitSize() + 1L;
            this.estimatedSize = (int)((long)this.estimatedSize + frameSize);
            if (split != null) {
                // empty if block
            }
            frame = split;
        }
        this.currentFrame = null;
        if (log.isTraceEnabled()) {
            log.trace("end of split frame.  Messages per frame:" + this.messagesPerFrame);
        }
    }

    protected void endMessage() throws IOException {
        long timestamp = this.timeSource.getTime();
        int id = this.nextMessageId++;
        ObjectStateMessage msg = new ObjectStateMessage(id, timestamp, null);
        msg.setReliable(false);
        msg.setState(this.outbound, this.objectProtocol);
        this.sentStates.add(this.outbound);
        if (log.isTraceEnabled()) {
            log.trace("Sending message ID:" + id);
        }
        this.conn.send((Message)msg);
        this.stats.addMessageSize(15 + msg.getBuffer().length);
        this.outbound = null;
    }

    public void flush() throws IOException {
        this.endFrame();
        if (this.outbound == null) {
            return;
        }
        this.endMessage();
    }
}

