/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.crig.jme;

import com.google.common.io.Resources;
import com.simsilica.crig.jme.RigTypeInitializer;
import com.simsilica.crig.jme.SpatialRigType;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyRigTypeInitializer
implements RigTypeInitializer,
Serializable {
    static Logger log = LoggerFactory.getLogger(GroovyRigTypeInitializer.class);
    static final long serialVersionUID = 42L;
    private static ScriptEngine engine;
    private static Bindings globalBindings;
    private static Function<String, String> resourceResolver;
    private String scriptResource;
    private transient String script;

    public GroovyRigTypeInitializer(String scriptResource) {
        this.scriptResource = scriptResource;
    }

    public static void setResourceResolver(Function<String, String> resourceResolver) {
        GroovyRigTypeInitializer.resourceResolver = resourceResolver;
    }

    protected String getScript() {
        if (this.script == null) {
            this.script = resourceResolver.apply(this.scriptResource);
        }
        log.info("script:\n" + this.script);
        return this.script;
    }

    @Override
    public void initializeRigType(SpatialRigType rigType) {
        log.info("initializeRigType(" + this.scriptResource + ")");
        Bindings bindings = engine.createBindings();
        bindings.putAll(globalBindings);
        String logName = this.scriptResource;
        if (logName.endsWith(".groovy")) {
            logName = logName.substring(0, logName.length() - ".groovy".length());
        }
        bindings.put("log", (Object)LoggerFactory.getLogger((String)("rigTypeInitializer." + logName)));
        bindings.put("rigType", (Object)rigType);
        try {
            engine.eval(this.getScript(), bindings);
        }
        catch (ScriptException e) {
            log.error("Error running script:\n" + this.getScript());
            throw new RuntimeException("Error running script:" + this.scriptResource, e);
        }
    }

    static {
        ScriptEngineManager mgr = new ScriptEngineManager();
        engine = mgr.getEngineByExtension("groovy");
        log.info("Engine:" + engine);
        if (engine == null) {
            throw new RuntimeException("No groovy script engine found");
        }
        globalBindings = engine.createBindings();
        resourceResolver = name -> {
            URL u = Resources.getResource((String)name);
            try {
                return Resources.toString((URL)u, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new RuntimeException("Error loading resource:" + u, e);
            }
        };
    }
}

