/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.map;

import com.jme3.math.Vector2f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.simsilica.lemur.component.IconComponent;
import mythruna.shape.IconName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasIconComponent
extends IconComponent {
    static Logger log = LoggerFactory.getLogger(AtlasIconComponent.class);
    private Integer xCell;
    private Integer yCell;

    public AtlasIconComponent(IconName iconName) {
        super(iconName.getImageName());
        this.xCell = iconName.getX();
        this.yCell = iconName.getY();
        this.resetTextureCoordinates();
    }

    public AtlasIconComponent clone() {
        AtlasIconComponent result = (AtlasIconComponent)super.clone();
        return result;
    }

    public void setCell(Integer xCell, Integer yCell) {
        this.xCell = xCell;
        this.yCell = yCell;
        this.resetTextureCoordinates();
    }

    protected void resetTextureCoordinates() {
        Geometry icon = this.getIcon();
        if (icon == null) {
            return;
        }
        Mesh mesh = icon.getMesh();
        if (this.xCell == null || this.yCell == null) {
            mesh.setBuffer(VertexBuffer.Type.TexCoord, 2, new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f});
        } else {
            float x = (float)this.xCell.intValue() / 8.0f;
            float y = (float)this.yCell.intValue() / 8.0f;
            float cellSize = 0.125f;
            mesh.setBuffer(VertexBuffer.Type.TexCoord, 2, new float[]{x, y, x + cellSize, y, x + cellSize, y + cellSize, x, y + cellSize});
        }
    }

    protected Geometry createIcon() {
        Geometry geom = super.createIcon();
        this.resetTextureCoordinates();
        return geom;
    }

    protected Vector2f getEffectiveIconSize() {
        return super.getEffectiveIconSize();
    }
}

