/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view.object;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.scene.Spatial;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.EntitySet;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mphys.DynArray;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import mythruna.assembly.MixControl;
import mythruna.client.GameSessionState;
import mythruna.client.view.object.Model;
import mythruna.client.view.object.ModelCounts;
import mythruna.client.view.object.ModelListener;
import mythruna.client.view.object.ModelViewState;
import mythruna.es.Morph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MorphViewState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(MorphViewState.class);
    private EntityData ed;
    private Map<EntityId, MorphView> viewIndex = new HashMap<EntityId, MorphView>();
    private DynArray<MorphView> activeViews = new DynArray(MorphView.class);
    private Set<MorphView> mixers = new HashSet<MorphView>();
    private ModelObserver modelObserver = new ModelObserver();
    private ConcurrentLinkedQueue<MorphView> checkRelease = new ConcurrentLinkedQueue();
    private ModelCounts counts;

    protected void initialize(Application app) {
        this.ed = ((GameSessionState)this.getState(GameSessionState.class)).getEntityData();
        ((ModelViewState)this.getState(ModelViewState.class, true)).addModelListener(this.modelObserver);
        this.counts = ((ModelViewState)this.getState(ModelViewState.class, true)).getModelCounts();
        this.counts.createView("Assms");
        this.counts.createView("Mixers");
    }

    protected void cleanup(Application app) {
        if (this.getState(ModelViewState.class) != null) {
            ((ModelViewState)this.getState(ModelViewState.class, true)).removeModelListener(this.modelObserver);
        }
    }

    protected void onEnable() {
    }

    protected void onDisable() {
    }

    public void update(float tpf) {
        this.releasePending();
        for (MorphView view : (MorphView[])this.activeViews.getArray()) {
            view.update();
        }
        this.counts.updateCount("Assms", this.activeViews.size());
        this.counts.updateCount("Mixers", this.mixers.size());
    }

    protected void releasePending() {
        MorphView view = null;
        while ((view = this.checkRelease.poll()) != null) {
            if (view.model != null) continue;
            this.removeView(view);
        }
    }

    protected boolean isAssembly(Model model) {
        String type = model.getShapeName().getType();
        if ("asm".equals(type)) {
            return true;
        }
        return "assembly".equals(type);
    }

    protected MorphView getView(EntityId entityId, boolean create) {
        MorphView view = this.viewIndex.get(entityId);
        if (view == null && create) {
            view = new MorphView(entityId);
            this.viewIndex.put(entityId, view);
        }
        return view;
    }

    protected void removeView(MorphView view) {
        this.viewIndex.remove(view.entityId);
        this.activeViews.remove((Object)view);
        view.release();
    }

    protected class MorphView {
        private EntityId entityId;
        private Model model;
        private VersionedReference<Spatial> spatialRef;
        private Spatial spatial;
        private MixControl mixControl;
        private EntitySet morphs;

        public MorphView(EntityId entityId) {
            this.entityId = entityId;
        }

        public void setModel(Model model) {
            if (this.model == model) {
                return;
            }
            this.model = model;
            if (log.isTraceEnabled()) {
                log.trace(this.entityId + ".setModel(" + model + ")");
            }
            if (this.model != null) {
                MorphViewState.this.activeViews.add((Object)this);
                this.spatialRef = this.model.createSpatialRef();
                this.updateSpatial((Spatial)this.spatialRef.get());
            } else {
                this.spatialRef = null;
                MorphViewState.this.activeViews.remove((Object)this);
            }
        }

        protected void activateMixing() {
            MorphViewState.this.mixers.add(this);
            if (this.morphs != null) {
                this.morphs.release();
            }
            this.morphs = MorphViewState.this.ed.getEntities(Morph.filter((EntityId)this.entityId), new Class[]{Morph.class});
            this.applyMorphs();
        }

        protected void deactivateMixing() {
            MorphViewState.this.mixers.remove(this);
            if (this.morphs != null) {
                this.morphs.release();
                this.morphs = null;
            }
        }

        protected void updateSpatial(Spatial spatial) {
            if (this.spatial == spatial) {
                return;
            }
            this.spatial = spatial;
            this.mixControl = spatial == null ? null : (MixControl)spatial.getControl(MixControl.class);
            if (this.mixControl != null) {
                this.activateMixing();
            } else {
                this.deactivateMixing();
            }
        }

        protected void applyMorphs() {
            if (this.mixControl == null) {
                return;
            }
            for (Entity e : this.morphs) {
                Morph morph = (Morph)e.get(Morph.class);
                this.mixControl.setMix(morph.getVerbString(MorphViewState.this.ed), morph.getMix());
            }
        }

        public void update() {
            if (this.spatialRef == null) {
                return;
            }
            if (this.spatialRef.update()) {
                this.updateSpatial((Spatial)this.spatialRef.get());
            }
            if (this.morphs != null && this.morphs.applyChanges()) {
                this.applyMorphs();
            }
        }

        public void release() {
            this.deactivateMixing();
            this.spatialRef = null;
            this.spatial = null;
            this.mixControl = null;
        }
    }

    protected class ModelObserver
    implements ModelListener {
        protected ModelObserver() {
        }

        @Override
        public void modelCreated(Model model) {
            if (MorphViewState.this.isAssembly(model)) {
                MorphViewState.this.getView(model.getEntityId(), true).setModel(model);
            }
        }

        @Override
        public void modelReleased(Model model) {
            MorphView view = MorphViewState.this.getView(model.getEntityId(), false);
            if (view != null) {
                view.setModel(null);
                MorphViewState.this.checkRelease.add(view);
            }
        }
    }
}

