/*
 * Copyright (c) 2022, Simsilica, LLC
 * All rights reserved.
 */

import java.lang.reflect.Modifier;

import com.simsilica.action.ActionEnvironment;
import com.simsilica.event.*;

import mythruna.net.AccountEvent;
import mythruna.net.server.GameSessionHostedService;


// For convenience, we'll expose the standard life cycle
// event constants directly so that we don't have to constantly
// refer to the event type:
PlayerEntityEvent.fields.each {
    if( Modifier.isStatic(it.getModifiers()) ) {
        log.info("Binding event type:" + it.name);
        binding.setProperty(it.name, it.get(null));
    }
}

AccountEvent.fields.each {
    if( Modifier.isStatic(it.getModifiers()) ) {
        log.info("Binding event type:" + it.name);
        binding.setProperty(it.name, it.get(null));
    }
}

PlayerEntityEvent.metaClass.getSession = {
    return GameSessionHostedService.getGameSession(delegate.connection);
}

class SavedListener {
    EventType type;
    EventListener listener;
}

registeredListeners = [];

on = { EventType eventType, Closure doIt ->

    log.info("************************************* on(" + eventType + ", " + doIt + ")");

    def listener = new EventListener() {
        @Override
        public void newEvent( EventType type, Object event ) {
            def actionEnv = null;
            if( event instanceof PlayerEntityEvent ) {
                // Early player events will not have a session yet... so we can't
                // push an environment.
                if( event.session ) {
                    actionEnv = event.session.actionEnvironment;
                } else {
                    // Make our own
                    actionEnv = objectTypes.createEnvironment(event.player);
                }
                ActionEnvironment.pushCurrentEnvironment(actionEnv);
            }
            try {
                // rehydrate(Object delegate, Object owner, Object thisObject)
                Closure c = doIt.rehydrate(this, doIt.owner, doIt);
                c(event);
            } catch( RuntimeException e ) {
                throw new EventAbortedException(e.getMessage(), e);
            } finally {
                if( actionEnv ) {
                    ActionEnvironment.popCurrentEnvironment(actionEnv);
                }
            }
        }
    };

    registeredListeners.add(new SavedListener(type:eventType, listener:listener));

    EventBus.addListener(eventType, listener);
}


cleanupHooks = {
    log.info("Cleanup hooks:" + registeredListeners);
    registeredListeners.each { SavedListener l ->
        log.info("Cleaning up listener for:" + l.type + " listener:" + l.listener);
        EventBus.removeListener(l.type, l.listener);
    }
}


